# CVE-2023-40028 Proof of Concept

This repository contains a proof of concept (POC) for CVE-2023-40028, demonstrating a vulnerability in the Ghost content management system where authenticated users can upload symlinks, leading to arbitrary file read vulnerabilities.

## Disclaimer

This POC is provided for educational and research purposes only. It is strictly forbidden to use this POC for illegal activities. The author of this POC assume no liability and is not responsible for any misuse or damage caused by this program.

## Vulnerability Summary

CVE-2023-40028 affects Ghost, an open source content management system, where versions prior to 5.59.1 allow authenticated users to upload files that are symlinks. This can be exploited to perform an arbitrary file read of any file on the host operating system. It is recommended that site administrators check for exploitation of this issue by looking for unknown symlinks within Ghost's `content/` folder. Version 5.59.1 contains a fix for this issue, and there are no known workarounds.

- **CVE ID**: CVE-2023-40028
- **CVSS Score**: 6.5 Medium
- **Affected Software**: Ghost versions before 5.59.1
- **Fixed in Version**: Ghost 5.59.1

## POC Overview

This POC demonstrates how to exploit CVE-2023-40028 by uploading a symlink to the vulnerable Ghost CMS to achieve arbitrary file read.

## Requirements

- Access to a vulnerable Ghost version (prior to 5.59.1)
- Authenticated user account

## Mitigation

Upgrade to Ghost version 5.59.1 or later, which contains the patch for this vulnerability. Regularly check your Ghost installation's `content/` folder for any unknown symlinks and remove them.

## References

- [CVE-2023-40028 on OpenCVE](https://www.opencve.io/cve/CVE-2023-40028)
- [CVE-2023-40028 on Mitre](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2023-40028)

For more detailed information about CVE-2023-40028, including the vulnerability details and mitigation advice, please refer to the provided references.
