import requests
import utils
import logging
import sys
from termcolor import colored,COLORS
from colorama import init

init(autoreset=True)
log = logging.getLogger(__name__)

class Uvdesk:
    def __init__(self, url, no_proxy):
        self.base_url = utils.normalize_url(url)
        self.login_url = self.base_url+"/en/member/login"
        self.no_proxy = no_proxy
        self.session = requests.Session()


    def login(self, _username, _password):
        log.info(colored("Getting login page.", "blue"))

        data = {
            "_username": _username,
            "_password": _password,
            "_remember_me":"on"
        }

        log.info(colored(f"Attempting to login with user: {_username} and password: {_password}","blue"))

        if self.no_proxy:
            resp = self.session.post(self.login_url, data=data, allow_redirects=False, verify=False)
        
        else:
            resp = self.session.post(self.login_url, data=data, proxies=utils.PROXIES, verify=False, allow_redirects=False) 

        if self.is_solved(resp):
            log.info(colored(f"Access granted with username: {_username} and password: {_password}","green"))
            sys.exit(0)
        else:
            log.warning(colored(f"Authentication failed for username: {_username} with password: {_password}","red"))


    def is_solved(self,resp):
        log.info(colored("Checking if the correct user has been identified.","blue"))
        if resp.status_code == 302 and f"{self.base_url}/en/member/dashboard" in resp.text:
            log.info(colored("Correct password found!","green"))
            return True
        else:
            return False

 