import sys
import logging
import argparse
import urllib3
from termcolor import colored,COLORS


PROXIES = {
    "http": "127.0.0.1:8080",
    "https": "127.0.0.1:8080",
}

urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)


log = logging.getLogger(__name__)
logging.basicConfig(
    stream=sys.stdout,
    level=logging.INFO,
    format="%(asctime)s [%(threadName)s] [%(levelname)s] %(message)s",
    style="%",
    datefmt="%H:%M:%S",
)

def parse_args(args: list):
    parser = argparse.ArgumentParser()
    parser.add_argument("-n", "--no-proxy", default=False, action="store_true", help="do not use proxy")
    parser.add_argument("url", help="url of lab")
    return parser.parse_args(args)

def normalize_url(url):
    URL = str(url.rstrip("/"))
    return URL


def banner():
    banner_text = """

 ▄▄▄▄▄▄▄▄▄▄▄  ▄▄▄▄▄▄▄▄▄▄▄  ▄▄▄▄▄▄▄▄▄▄▄  ▄▄▄▄▄▄▄▄▄▄▄ 
▐░░░░░░░░░░░▌▐░░░░░░░░░░░▌▐░░░░░░░░░░░▌▐░░░░░░░░░░░▌
▐░█▀▀▀▀▀▀▀▀▀ ▐░█▀▀▀▀▀▀▀▀▀  ▀▀▀▀█░█▀▀▀▀ ▐░█▀▀▀▀▀▀▀▀▀ 
▐░▌          ▐░▌               ▐░▌     ▐░▌          
▐░▌          ▐░█▄▄▄▄▄▄▄▄▄      ▐░▌     ▐░▌          
▐░▌          ▐░░░░░░░░░░░▌     ▐░▌     ▐░▌          
▐░▌           ▀▀▀▀▀▀▀▀▀█░▌     ▐░▌     ▐░▌          
▐░▌                    ▐░▌     ▐░▌     ▐░▌          
▐░█▄▄▄▄▄▄▄▄▄  ▄▄▄▄▄▄▄▄▄█░▌     ▐░▌     ▐░█▄▄▄▄▄▄▄▄▄ 
▐░░░░░░░░░░░▌▐░░░░░░░░░░░▌     ▐░▌     ▐░░░░░░░░░░░▌
 ▀▀▀▀▀▀▀▀▀▀▀  ▀▀▀▀▀▀▀▀▀▀▀       ▀       ▀▀▀▀▀▀▀▀▀▀▀ 
                                                    


        """
    print(colored(banner_text, "cyan"))


    

