# CVE-2023-35086-POC
> July 25 2023, Altin (tin-z), github.com/tin-z

---

## Brief description ##

ASUS RT-AX56U V2 & RT-AC86U router firmwares below or equal to version 3.0.0.4.386_50460 and 3.0.0.4_386_51529 respectively have a format string vulnerability in the detwan.cgi function of the httpd service that can cause code execution when an attacker constructs malicious data. The vulnerability affects also other ASUS devices using httpd service. Read here for more [details](#details).


references:
 * [mitre report](https://cve.mitre.org/cgi-bin/cvename.cgi?name=2023-35086)
 * [cve.report](https://cve.report/CVE-2023-35086)


## Poc ##


The vulnerability permits achieving RCE, meanwhile the PoC only achieves DoS, mainly because the firmware was emulated with QEMU and so the stack is different from the real case device. Prerequisites:
 - The value of 'Referer' header should contain the target's address

[poc_crash.py](./poc_crash.py)

```
virtualenv --python=python3 .venv
source .venv/bin/activate
pip install hexdump

python poc_crash.py --HOST 127.0.0.1 --PORT 12234 --test
# output expected: [+] Target supports detwan.cgi


python poc_crash.py --HOST 127.0.0.1 --PORT 12234 --dos
```

![poc.gif](./img/poc.gif)


<br/>

## details ###

The vulnerability is triggered by doing GET or POST to uri `/detwan.cgi` and giving a special format string as argument to `action_mode` HTTP parameter.

By opening httpd binary in ghidra we can see the string "do_detwan_cgi" referenced by address `0x492c4`

![t1.jpg](./img/t1.jpg)

The decompiler breaks down the function without showing everything, but the interesting points are already there:
 - `FUN_0001b70c` extracts the parameter `action_mode`
 - `logmessage_normal` is an external function exposed by libshared

![t2.jpg](./img/t2.jpg)


The source code of `logmessage_normal` can be found in the asuswrt-merlin firmware, specifically in the file `asuswrt-merlin/release/src/router/shared/misc.c`, and as can be noted, it saves `action_mode`'s content inside the local variable `buf`, which in turn is used on `syslog` call

![t3.jpg](./img/t3.jpg)


The libc `syslog` supports format strings so here's the root of the vulnerability

![t4.jpg](./img/t4.jpg)




