<h1 align="center">Ivanti Connect Secure VPN Privilege Escalation</h1>
<p align="center">
    <b>Ivanti Secure Access (previously Pulse Secure) privilege escalation Cobalt Strike BOF (CVE-2023-35080).</b>
    <br/>
    <sup>Exploit by <a href="https://github.com/lldre">Alex</a> and BOF by <a href="https://github.com/tijme">Tijme</a>. Made possible by <a href="https://northwave-cybersecurity.com/">Northwave Cyber Security</a> <img src="https://github.com/tijme/ivanti-cve-2023-35080-privilege-escalation-bof/blob/master/.github/northwave.png?raw=true"/></sup>
    <br/>
</p>

## Description

This is a Cobalt Strike (CS) Beacon Object File (BOF) and executable which exploits Ivanti Secure Access (previously Pulse Secure) VPN client ([CVE-2023-35080](https://forums.ivanti.com/s/article/Security-fixes-included-in-the-latest-Ivanti-Secure-Access-Client-Release)). From a low-privileged user mode, it exploits a vulnerability in the kernel driver to overwrite the beacon process token privileges with a system process token privileges. The kernel driver symbolic link has an ACL defining that `Everyone` can open a handle to it. The research that led to finding this vulnerability has been presented at RedTreat 2023 and BSIDES London 2023 ([presentation](https://github.com/tijme/ivanti-cve-2023-35080-privilege-escalation-bof/blob/master/.github/presentation.pdf)).

The exploit has been developed on Windows 10 Pro 22H2 10.0.19045 (x64). It was later modified and tested to work on Windows 11 Pro 23H2 22631 (x64). Other versions of Windows might not be supported out of the box. Full list of supported Windows tested:

* Windows 10 Pro 22H2 10.0.19045 (x64)
* Windows 11 Pro 23H2 10.0.22621 (x64)
* Windows 11 Pro 23H2 10.0.22631 (x64)

<p align="center">
    <a href="https://github.com/tijme/ivanti-cve-2023-35080-privilege-escalation-bof/blob/master/.github/demo.mov?raw=true">
        <img src="https://github.com/tijme/ivanti-cve-2023-35080-privilege-escalation-bof/blob/master/.github/demo.gif?raw=true" width="1000"/>
    </a>
</p>

## Usage

Clone this repository first. Then review the code, compile from source (requires [MinGW](https://www.mingw-w64.org/)) and use it in Cobalt Strike or as a standalone PE-file.

### Compile to PE and BOF

    make

### Usage of the exploit

Important! Perform the following steps in order (from low-privileged user mode):
1. [Start the vulnerable driver](#start-the-vulnerable-driver)
2. [Stop the VPN client](#stop-the-vpn-client)
3. [Run the exploit](#run-the-exploit)

#### 1. Start the vulnerable driver
First, ensure that the vulnerable driver is running. If it's not running, don't worry! You can start it from low-privileged user mode. The driver name starts with `jnprTdi_`, and can be found at `HKLM\SYSTEM\CurrentControlSet\Services`. It is always installed when the VPN client is installed, but it's not running by default. 

The vulnerable driver *does* start when a (low-privileged) user on the victim machine connects to a (rogue) VPN server that has the TDI fail-over option enabled. We can quite easily start the driver ourselves by replicating that behaviour, as we have already compromised a system and are running malware on it. Follow [this](https://github.com/tijme/ivanti-cve-2023-35080-privilege-escalation-bof/blob/master/docs/SETUP_ROGUE_SERVER.md) guide to configure your own rogue appliance with TDI fail-over enabled.

#### 2. Stop the VPN client

    "%programfiles(x86)%\Common Files\Pulse Secure\Integration\pulselauncher.exe" -stop

#### 3. Run the exploit
If the driver is running, and the VPN client is stopped, load the `PulsePrivEsc.cna` script using the Cobalt Strike Script Manager. Then use the command below to execute the exploit.

    $ pulse_priv_esc

Alternatively (and for testing purposes), you can directly run the compiled executable. This will spawn a command prompt as SYSTEM.

    $ .\PulsePrivEsc.x64.exe

## Limitations

* If the driver is not running, it has to be started manually using by connecting to a rogue VPN server. This *can* be done from low-privileged user mode though.
* The VPN client needs to be stopped (or at least have no active connections), as otherwise calls to the vulnerable IOCTL will corrupt memory while exploitation is in process.
* The eventually elevated process cannot quit as its threads will never stop. If you'd like to, you can change the exploit to stop terminate the threads after successful execution.
* The exploit has only been tested on three Windows versions. It needs to obtain offsets to un-exported functions in the kernel, which are found by pattern searches. These searches might fail on other versions of Windows.

## Issues

Issues or new features can be reported via the [issue tracker](https://github.com/tijme/ivanti-cve-2023-35080-privilege-escalation-bof/issues). Please make sure your issue or feature has not yet been reported by anyone else before submitting a new one.

## Copyright

Copyright (c) 2023 Northwave Cyber Security. All rights reserved. 