# CVE-2023-33617

Authenticated OS command injection vulnerability (CVE-2023-33617) in Parks FiberLink 210 routers running firmware version V2.1.14_X000. This tool utilizes the APIs of ZoomEye and Shodan to search for vulnerable targets and then attempts to exploit the command injection vulnerability.

## Prerequisites

- Python 3.x
- Install the required dependencies using the provided `requirements.txt` file: `pip install -r requirements.txt`

## Usage

1. Export the API keys for ZoomEye and Shodan as environment variables:
   - ZoomEye API key: `export ZOOMEYE_API_KEY=Your_Zoomeye_API_Key`
   - Shodan API key: `export SHODAN_API_KEY=Your_Shodan_API_Key`
2. Run the `exploiter.py` script with the desired options:

```bash
python exploiter.py --shodan --zoomeye --threads 10 --pages 2 --user admin --password parks --output vulnerable.txt
```

## Options

- `--shodan`: Use Shodan API for target search
- `--zoomeye`: Use ZoomEye API for target search
- `--threads`: Number of threads to use for concurrent exploitation (default: 100)
- `--pages`: Number of pages to search in ZoomEye or Shodan (default: 1)
- `--user`: Username for authentication (default: admin)
- `--password`: Password for authentication (default: parks)
- `--output`: Output file to store the list of vulnerable hosts (default: vulnerable.txt)

## Output

The tool will display the progress and results of the exploitation process. It will print the vulnerable hosts and their command output. Additionally, the list of vulnerable hosts will be saved in the specified output file.

## Disclaimer

This tool is intended for educational and ethical purposes only. The authors are not responsible for any misuse or damage caused by this tool. Use it at your own risk.

## Credits
Original Write-Up: [https://blog.gbrls.space/blog/cve-2023-33617-writeup/](https://blog.gbrls.space/blog/cve-2023-33617-writeup/)

