/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.stats;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.admin.ConsumeStats;
import org.apache.rocketmq.common.protocol.body.BrokerStatsData;
import org.apache.rocketmq.common.protocol.body.GroupList;
import org.apache.rocketmq.common.protocol.body.TopicList;
import org.apache.rocketmq.common.protocol.route.BrokerData;
import org.apache.rocketmq.common.protocol.route.TopicRouteData;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class StatsAllSubCommand
implements SubCommand {
    public static void printTopicDetail(DefaultMQAdminExt admin, String topic, boolean activeTopic) throws RemotingException, MQClientException, InterruptedException, MQBrokerException {
        TopicRouteData topicRouteData = admin.examineTopicRouteInfo(topic);
        GroupList groupList = admin.queryTopicConsumeByWho(topic);
        double inTPS = 0.0;
        long inMsgCntToday = 0L;
        for (BrokerData bd : topicRouteData.getBrokerDatas()) {
            String masterAddr = bd.getBrokerAddrs().get(0L);
            if (masterAddr == null) continue;
            try {
                BrokerStatsData bsd = admin.viewBrokerStatsData(masterAddr, "TOPIC_PUT_NUMS", topic);
                inTPS += bsd.getStatsMinute().getTps();
                inMsgCntToday += StatsAllSubCommand.compute24HourSum(bsd);
            }
            catch (Exception exception) {}
        }
        if (groupList != null && !groupList.getGroupList().isEmpty()) {
            for (String group : groupList.getGroupList()) {
                double outTPS = 0.0;
                long outMsgCntToday = 0L;
                for (BrokerData bd : topicRouteData.getBrokerDatas()) {
                    String masterAddr = bd.getBrokerAddrs().get(0L);
                    if (masterAddr == null) continue;
                    try {
                        String statsKey = String.format("%s@%s", topic, group);
                        BrokerStatsData bsd = admin.viewBrokerStatsData(masterAddr, "GROUP_GET_NUMS", statsKey);
                        outTPS += bsd.getStatsMinute().getTps();
                        outMsgCntToday += StatsAllSubCommand.compute24HourSum(bsd);
                    }
                    catch (Exception exception) {}
                }
                long accumulate = 0L;
                try {
                    ConsumeStats consumeStats = admin.examineConsumeStats(group, topic);
                    if (consumeStats != null && (accumulate = consumeStats.computeTotalDiff()) < 0L) {
                        accumulate = 0L;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (activeTopic && inMsgCntToday <= 0L && outMsgCntToday <= 0L) continue;
                System.out.printf("%-32s  %-32s %12d %11.2f %11.2f %14d %14d%n", UtilAll.frontStringAtLeast(topic, 32), UtilAll.frontStringAtLeast(group, 32), accumulate, inTPS, outTPS, inMsgCntToday, outMsgCntToday);
            }
        } else if (!activeTopic || inMsgCntToday > 0L) {
            System.out.printf("%-32s  %-32s %12d %11.2f %11s %14d %14s%n", UtilAll.frontStringAtLeast(topic, 32), "", 0, inTPS, "", inMsgCntToday, "NO_CONSUMER");
        }
    }

    public static long compute24HourSum(BrokerStatsData bsd) {
        if (bsd.getStatsDay().getSum() != 0L) {
            return bsd.getStatsDay().getSum();
        }
        if (bsd.getStatsHour().getSum() != 0L) {
            return bsd.getStatsHour().getSum();
        }
        if (bsd.getStatsMinute().getSum() != 0L) {
            return bsd.getStatsMinute().getSum();
        }
        return 0L;
    }

    @Override
    public String commandName() {
        return "statsAll";
    }

    @Override
    public String commandDesc() {
        return "Topic and Consumer tps stats";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        Option opt = new Option("a", "activeTopic", false, "print active topic only");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("t", "topic", true, "print select topic only");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            defaultMQAdminExt.start();
            TopicList topicList = defaultMQAdminExt.fetchAllTopicList();
            System.out.printf("%-32s  %-32s %12s %11s %11s %14s %14s%n", "#Topic", "#Consumer Group", "#Accumulation", "#InTPS", "#OutTPS", "#InMsg24Hour", "#OutMsg24Hour");
            boolean activeTopic = commandLine.hasOption('a');
            String selectTopic = commandLine.getOptionValue('t');
            for (String topic : topicList.getTopicList()) {
                if (topic.startsWith("%RETRY%") || topic.startsWith("%DLQ%") || selectTopic != null && !selectTopic.isEmpty() && !topic.equals(selectTopic)) continue;
                try {
                    StatsAllSubCommand.printTopicDetail(defaultMQAdminExt, topic, activeTopic);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }
}

