/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.schedule;

import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.rocketmq.common.ConfigManager;
import org.apache.rocketmq.common.TopicFilterType;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.running.RunningStats;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;
import org.apache.rocketmq.store.ConsumeQueue;
import org.apache.rocketmq.store.ConsumeQueueExt;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.MessageExtBrokerInner;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.PutMessageResult;
import org.apache.rocketmq.store.PutMessageStatus;
import org.apache.rocketmq.store.SelectMappedBufferResult;
import org.apache.rocketmq.store.config.StorePathConfigHelper;
import org.apache.rocketmq.store.schedule.DelayOffsetSerializeWrapper;

public class ScheduleMessageService
extends ConfigManager {
    private static final InternalLogger log = InternalLoggerFactory.getLogger("RocketmqStore");
    private static final long FIRST_DELAY_TIME = 1000L;
    private static final long DELAY_FOR_A_WHILE = 100L;
    private static final long DELAY_FOR_A_PERIOD = 10000L;
    private final ConcurrentMap<Integer, Long> delayLevelTable = new ConcurrentHashMap<Integer, Long>(32);
    private final ConcurrentMap<Integer, Long> offsetTable = new ConcurrentHashMap<Integer, Long>(32);
    private final DefaultMessageStore defaultMessageStore;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private Timer timer;
    private MessageStore writeMessageStore;
    private int maxDelayLevel;

    public ScheduleMessageService(DefaultMessageStore defaultMessageStore) {
        this.defaultMessageStore = defaultMessageStore;
        this.writeMessageStore = defaultMessageStore;
    }

    public static int queueId2DelayLevel(int queueId) {
        return queueId + 1;
    }

    public static int delayLevel2QueueId(int delayLevel) {
        return delayLevel - 1;
    }

    public void setWriteMessageStore(MessageStore writeMessageStore) {
        this.writeMessageStore = writeMessageStore;
    }

    public void buildRunningStats(HashMap<String, String> stats) {
        for (Map.Entry next : this.offsetTable.entrySet()) {
            int queueId = ScheduleMessageService.delayLevel2QueueId((Integer)next.getKey());
            long delayOffset = (Long)next.getValue();
            long maxOffset = this.defaultMessageStore.getMaxOffsetInQueue("SCHEDULE_TOPIC_XXXX", queueId);
            String value = String.format("%d,%d", delayOffset, maxOffset);
            String key = String.format("%s_%d", RunningStats.scheduleMessageOffset.name(), next.getKey());
            stats.put(key, value);
        }
    }

    private void updateOffset(int delayLevel, long offset) {
        this.offsetTable.put(delayLevel, offset);
    }

    public long computeDeliverTimestamp(int delayLevel, long storeTimestamp) {
        Long time = (Long)this.delayLevelTable.get(delayLevel);
        if (time != null) {
            return time + storeTimestamp;
        }
        return storeTimestamp + 1000L;
    }

    public void start() {
        if (this.started.compareAndSet(false, true)) {
            super.load();
            this.timer = new Timer("ScheduleMessageTimerThread", true);
            for (Map.Entry entry : this.delayLevelTable.entrySet()) {
                Integer level = (Integer)entry.getKey();
                Long timeDelay = (Long)entry.getValue();
                Long offset = (Long)this.offsetTable.get(level);
                if (null == offset) {
                    offset = 0L;
                }
                if (timeDelay == null) continue;
                this.timer.schedule((TimerTask)new DeliverDelayedMessageTimerTask(level, offset), 1000L);
            }
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    try {
                        if (ScheduleMessageService.this.started.get()) {
                            ScheduleMessageService.this.persist();
                        }
                    }
                    catch (Throwable e) {
                        log.error("scheduleAtFixedRate flush exception", e);
                    }
                }
            }, 10000L, this.defaultMessageStore.getMessageStoreConfig().getFlushDelayOffsetInterval());
        }
    }

    public void shutdown() {
        if (this.started.compareAndSet(true, false) && null != this.timer) {
            this.timer.cancel();
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public int getMaxDelayLevel() {
        return this.maxDelayLevel;
    }

    @Override
    public String encode() {
        return this.encode(false);
    }

    @Override
    public boolean load() {
        boolean result = super.load();
        result = result && this.parseDelayLevel();
        return result;
    }

    @Override
    public String configFilePath() {
        return StorePathConfigHelper.getDelayOffsetStorePath(this.defaultMessageStore.getMessageStoreConfig().getStorePathRootDir());
    }

    @Override
    public void decode(String jsonString) {
        DelayOffsetSerializeWrapper delayOffsetSerializeWrapper;
        if (jsonString != null && (delayOffsetSerializeWrapper = DelayOffsetSerializeWrapper.fromJson(jsonString, DelayOffsetSerializeWrapper.class)) != null) {
            this.offsetTable.putAll(delayOffsetSerializeWrapper.getOffsetTable());
        }
    }

    @Override
    public String encode(boolean prettyFormat) {
        DelayOffsetSerializeWrapper delayOffsetSerializeWrapper = new DelayOffsetSerializeWrapper();
        delayOffsetSerializeWrapper.setOffsetTable(this.offsetTable);
        return delayOffsetSerializeWrapper.toJson(prettyFormat);
    }

    public boolean parseDelayLevel() {
        HashMap<String, Long> timeUnitTable = new HashMap<String, Long>();
        timeUnitTable.put("s", 1000L);
        timeUnitTable.put("m", 60000L);
        timeUnitTable.put("h", 3600000L);
        timeUnitTable.put("d", 86400000L);
        String levelString = this.defaultMessageStore.getMessageStoreConfig().getMessageDelayLevel();
        try {
            String[] levelArray = levelString.split(" ");
            for (int i = 0; i < levelArray.length; ++i) {
                String value = levelArray[i];
                String ch = value.substring(value.length() - 1);
                Long tu = (Long)timeUnitTable.get(ch);
                int level = i + 1;
                if (level > this.maxDelayLevel) {
                    this.maxDelayLevel = level;
                }
                long num = Long.parseLong(value.substring(0, value.length() - 1));
                long delayTimeMillis = tu * num;
                this.delayLevelTable.put(level, delayTimeMillis);
            }
        }
        catch (Exception e) {
            log.error("parseDelayLevel exception", e);
            log.info("levelString String = {}", (Object)levelString);
            return false;
        }
        return true;
    }

    class DeliverDelayedMessageTimerTask
    extends TimerTask {
        private final int delayLevel;
        private final long offset;

        public DeliverDelayedMessageTimerTask(int delayLevel, long offset) {
            this.delayLevel = delayLevel;
            this.offset = offset;
        }

        @Override
        public void run() {
            try {
                if (ScheduleMessageService.this.isStarted()) {
                    this.executeOnTimeup();
                }
            }
            catch (Exception e) {
                log.error("ScheduleMessageService, executeOnTimeup exception", e);
                ScheduleMessageService.this.timer.schedule((TimerTask)new DeliverDelayedMessageTimerTask(this.delayLevel, this.offset), 10000L);
            }
        }

        private long correctDeliverTimestamp(long now, long deliverTimestamp) {
            long result = deliverTimestamp;
            long maxTimestamp = now + (Long)ScheduleMessageService.this.delayLevelTable.get(this.delayLevel);
            if (deliverTimestamp > maxTimestamp) {
                result = now;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void executeOnTimeup() {
            ConsumeQueue cq = ScheduleMessageService.this.defaultMessageStore.findConsumeQueue("SCHEDULE_TOPIC_XXXX", ScheduleMessageService.delayLevel2QueueId(this.delayLevel));
            long failScheduleOffset = this.offset;
            if (cq != null) {
                SelectMappedBufferResult bufferCQ = cq.getIndexBuffer(this.offset);
                if (bufferCQ != null) {
                    try {
                        int i;
                        long nextOffset = this.offset;
                        ConsumeQueueExt.CqExtUnit cqExtUnit = new ConsumeQueueExt.CqExtUnit();
                        for (i = 0; i < bufferCQ.getSize(); i += 20) {
                            long offsetPy = bufferCQ.getByteBuffer().getLong();
                            int sizePy = bufferCQ.getByteBuffer().getInt();
                            long tagsCode = bufferCQ.getByteBuffer().getLong();
                            if (cq.isExtAddr(tagsCode)) {
                                if (cq.getExt(tagsCode, cqExtUnit)) {
                                    tagsCode = cqExtUnit.getTagsCode();
                                } else {
                                    log.error("[BUG] can't find consume queue extend file content!addr={}, offsetPy={}, sizePy={}", tagsCode, offsetPy, sizePy);
                                    long msgStoreTime = ScheduleMessageService.this.defaultMessageStore.getCommitLog().pickupStoreTimestamp(offsetPy, sizePy);
                                    tagsCode = ScheduleMessageService.this.computeDeliverTimestamp(this.delayLevel, msgStoreTime);
                                }
                            }
                            long now = System.currentTimeMillis();
                            long deliverTimestamp = this.correctDeliverTimestamp(now, tagsCode);
                            nextOffset = this.offset + (long)(i / 20);
                            long countdown = deliverTimestamp - now;
                            if (countdown <= 0L) {
                                MessageExt msgExt = ScheduleMessageService.this.defaultMessageStore.lookMessageByOffset(offsetPy, sizePy);
                                if (msgExt == null) continue;
                                try {
                                    MessageExtBrokerInner msgInner = this.messageTimeup(msgExt);
                                    if ("RMQ_SYS_TRANS_HALF_TOPIC".equals(msgInner.getTopic())) {
                                        log.error("[BUG] the real topic of schedule msg is {}, discard the msg. msg={}", (Object)msgInner.getTopic(), (Object)msgInner);
                                        continue;
                                    }
                                    PutMessageResult putMessageResult = ScheduleMessageService.this.writeMessageStore.putMessage(msgInner);
                                    if (putMessageResult != null && putMessageResult.getPutMessageStatus() == PutMessageStatus.PUT_OK) {
                                        if (ScheduleMessageService.this.defaultMessageStore.getMessageStoreConfig().isEnableScheduleMessageStats()) {
                                            ScheduleMessageService.this.defaultMessageStore.getBrokerStatsManager().incTopicPutNums(msgInner.getTopic(), putMessageResult.getAppendMessageResult().getMsgNum(), 1);
                                            ScheduleMessageService.this.defaultMessageStore.getBrokerStatsManager().incTopicPutSize(msgInner.getTopic(), putMessageResult.getAppendMessageResult().getWroteBytes());
                                            ScheduleMessageService.this.defaultMessageStore.getBrokerStatsManager().incBrokerPutNums(putMessageResult.getAppendMessageResult().getMsgNum());
                                        }
                                        continue;
                                    }
                                    log.error("ScheduleMessageService, a message time up, but reput it failed, topic: {} msgId {}", (Object)msgExt.getTopic(), (Object)msgExt.getMsgId());
                                    ScheduleMessageService.this.timer.schedule((TimerTask)new DeliverDelayedMessageTimerTask(this.delayLevel, nextOffset), 10000L);
                                    ScheduleMessageService.this.updateOffset(this.delayLevel, nextOffset);
                                    return;
                                }
                                catch (Exception e) {
                                    log.error("ScheduleMessageService, messageTimeup execute error, drop it. msgExt=" + msgExt + ", nextOffset=" + nextOffset + ",offsetPy=" + offsetPy + ",sizePy=" + sizePy, e);
                                }
                                continue;
                            }
                            ScheduleMessageService.this.timer.schedule((TimerTask)new DeliverDelayedMessageTimerTask(this.delayLevel, nextOffset), countdown);
                            ScheduleMessageService.this.updateOffset(this.delayLevel, nextOffset);
                            return;
                        }
                        nextOffset = this.offset + (long)(i / 20);
                        ScheduleMessageService.this.timer.schedule((TimerTask)new DeliverDelayedMessageTimerTask(this.delayLevel, nextOffset), 100L);
                        ScheduleMessageService.this.updateOffset(this.delayLevel, nextOffset);
                        return;
                    }
                    finally {
                        bufferCQ.release();
                    }
                }
                long cqMinOffset = cq.getMinOffsetInQueue();
                if (this.offset < cqMinOffset) {
                    failScheduleOffset = cqMinOffset;
                    log.error("schedule CQ offset invalid. offset=" + this.offset + ", cqMinOffset=" + cqMinOffset + ", queueId=" + cq.getQueueId());
                }
            }
            ScheduleMessageService.this.timer.schedule((TimerTask)new DeliverDelayedMessageTimerTask(this.delayLevel, failScheduleOffset), 100L);
        }

        private MessageExtBrokerInner messageTimeup(MessageExt msgExt) {
            MessageExtBrokerInner msgInner = new MessageExtBrokerInner();
            msgInner.setBody(msgExt.getBody());
            msgInner.setFlag(msgExt.getFlag());
            MessageAccessor.setProperties(msgInner, msgExt.getProperties());
            TopicFilterType topicFilterType = MessageExt.parseTopicFilterType(msgInner.getSysFlag());
            long tagsCodeValue = MessageExtBrokerInner.tagsString2tagsCode(topicFilterType, msgInner.getTags());
            msgInner.setTagsCode(tagsCodeValue);
            msgInner.setPropertiesString(MessageDecoder.messageProperties2String(msgExt.getProperties()));
            msgInner.setSysFlag(msgExt.getSysFlag());
            msgInner.setBornTimestamp(msgExt.getBornTimestamp());
            msgInner.setBornHost(msgExt.getBornHost());
            msgInner.setStoreHost(msgExt.getStoreHost());
            msgInner.setReconsumeTimes(msgExt.getReconsumeTimes());
            msgInner.setWaitStoreMsgOK(false);
            MessageAccessor.clearProperty(msgInner, "DELAY");
            msgInner.setTopic(msgInner.getProperty("REAL_TOPIC"));
            String queueIdStr = msgInner.getProperty("REAL_QID");
            int queueId = Integer.parseInt(queueIdStr);
            msgInner.setQueueId(queueId);
            return msgInner;
        }
    }
}

