/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.impl.consumer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.rocketmq.client.consumer.AllocateMessageQueueStrategy;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.impl.FindBrokerResult;
import org.apache.rocketmq.client.impl.consumer.ProcessQueue;
import org.apache.rocketmq.client.impl.consumer.PullRequest;
import org.apache.rocketmq.client.impl.factory.MQClientInstance;
import org.apache.rocketmq.client.log.ClientLogger;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.protocol.body.LockBatchRequestBody;
import org.apache.rocketmq.common.protocol.body.UnlockBatchRequestBody;
import org.apache.rocketmq.common.protocol.heartbeat.ConsumeType;
import org.apache.rocketmq.common.protocol.heartbeat.MessageModel;
import org.apache.rocketmq.common.protocol.heartbeat.SubscriptionData;
import org.apache.rocketmq.logging.InternalLogger;

public abstract class RebalanceImpl {
    protected static final InternalLogger log = ClientLogger.getLog();
    protected final ConcurrentMap<MessageQueue, ProcessQueue> processQueueTable = new ConcurrentHashMap<MessageQueue, ProcessQueue>(64);
    protected final ConcurrentMap<String, Set<MessageQueue>> topicSubscribeInfoTable = new ConcurrentHashMap<String, Set<MessageQueue>>();
    protected final ConcurrentMap<String, SubscriptionData> subscriptionInner = new ConcurrentHashMap<String, SubscriptionData>();
    protected String consumerGroup;
    protected MessageModel messageModel;
    protected AllocateMessageQueueStrategy allocateMessageQueueStrategy;
    protected MQClientInstance mQClientFactory;

    public RebalanceImpl(String consumerGroup, MessageModel messageModel, AllocateMessageQueueStrategy allocateMessageQueueStrategy, MQClientInstance mQClientFactory) {
        this.consumerGroup = consumerGroup;
        this.messageModel = messageModel;
        this.allocateMessageQueueStrategy = allocateMessageQueueStrategy;
        this.mQClientFactory = mQClientFactory;
    }

    public void unlock(MessageQueue mq, boolean oneway) {
        FindBrokerResult findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(mq.getBrokerName(), 0L, true);
        if (findBrokerResult != null) {
            UnlockBatchRequestBody requestBody = new UnlockBatchRequestBody();
            requestBody.setConsumerGroup(this.consumerGroup);
            requestBody.setClientId(this.mQClientFactory.getClientId());
            requestBody.getMqSet().add(mq);
            try {
                this.mQClientFactory.getMQClientAPIImpl().unlockBatchMQ(findBrokerResult.getBrokerAddr(), requestBody, 1000L, oneway);
                log.warn("unlock messageQueue. group:{}, clientId:{}, mq:{}", this.consumerGroup, this.mQClientFactory.getClientId(), mq);
            }
            catch (Exception e) {
                log.error("unlockBatchMQ exception, " + mq, e);
            }
        }
    }

    public void unlockAll(boolean oneway) {
        HashMap<String, Set<MessageQueue>> brokerMqs = this.buildProcessQueueTableByBrokerName();
        for (Map.Entry<String, Set<MessageQueue>> entry : brokerMqs.entrySet()) {
            FindBrokerResult findBrokerResult;
            String brokerName = entry.getKey();
            Set<MessageQueue> mqs = entry.getValue();
            if (mqs.isEmpty() || (findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(brokerName, 0L, true)) == null) continue;
            UnlockBatchRequestBody requestBody = new UnlockBatchRequestBody();
            requestBody.setConsumerGroup(this.consumerGroup);
            requestBody.setClientId(this.mQClientFactory.getClientId());
            requestBody.setMqSet(mqs);
            try {
                this.mQClientFactory.getMQClientAPIImpl().unlockBatchMQ(findBrokerResult.getBrokerAddr(), requestBody, 1000L, oneway);
                for (MessageQueue mq : mqs) {
                    ProcessQueue processQueue = (ProcessQueue)this.processQueueTable.get(mq);
                    if (processQueue == null) continue;
                    processQueue.setLocked(false);
                    log.info("the message queue unlock OK, Group: {} {}", (Object)this.consumerGroup, (Object)mq);
                }
            }
            catch (Exception e) {
                log.error("unlockBatchMQ exception, " + mqs, e);
            }
        }
    }

    private HashMap<String, Set<MessageQueue>> buildProcessQueueTableByBrokerName() {
        HashMap<String, Set<MessageQueue>> result = new HashMap<String, Set<MessageQueue>>();
        for (MessageQueue mq : this.processQueueTable.keySet()) {
            Set<MessageQueue> mqs = result.get(mq.getBrokerName());
            if (null == mqs) {
                mqs = new HashSet<MessageQueue>();
                result.put(mq.getBrokerName(), mqs);
            }
            mqs.add(mq);
        }
        return result;
    }

    public boolean lock(MessageQueue mq) {
        FindBrokerResult findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(mq.getBrokerName(), 0L, true);
        if (findBrokerResult != null) {
            LockBatchRequestBody requestBody = new LockBatchRequestBody();
            requestBody.setConsumerGroup(this.consumerGroup);
            requestBody.setClientId(this.mQClientFactory.getClientId());
            requestBody.getMqSet().add(mq);
            try {
                Set<MessageQueue> lockedMq = this.mQClientFactory.getMQClientAPIImpl().lockBatchMQ(findBrokerResult.getBrokerAddr(), requestBody, 1000L);
                for (MessageQueue mmqq : lockedMq) {
                    ProcessQueue processQueue = (ProcessQueue)this.processQueueTable.get(mmqq);
                    if (processQueue == null) continue;
                    processQueue.setLocked(true);
                    processQueue.setLastLockTimestamp(System.currentTimeMillis());
                }
                boolean lockOK = lockedMq.contains(mq);
                log.info("the message queue lock {}, {} {}", lockOK ? "OK" : "Failed", this.consumerGroup, mq);
                return lockOK;
            }
            catch (Exception e) {
                log.error("lockBatchMQ exception, " + mq, e);
            }
        }
        return false;
    }

    public void lockAll() {
        HashMap<String, Set<MessageQueue>> brokerMqs = this.buildProcessQueueTableByBrokerName();
        for (Map.Entry<String, Set<MessageQueue>> entry : brokerMqs.entrySet()) {
            FindBrokerResult findBrokerResult;
            String brokerName = entry.getKey();
            Set<MessageQueue> mqs = entry.getValue();
            if (mqs.isEmpty() || (findBrokerResult = this.mQClientFactory.findBrokerAddressInSubscribe(brokerName, 0L, true)) == null) continue;
            LockBatchRequestBody requestBody = new LockBatchRequestBody();
            requestBody.setConsumerGroup(this.consumerGroup);
            requestBody.setClientId(this.mQClientFactory.getClientId());
            requestBody.setMqSet(mqs);
            try {
                ProcessQueue processQueue;
                Set<MessageQueue> lockOKMQSet = this.mQClientFactory.getMQClientAPIImpl().lockBatchMQ(findBrokerResult.getBrokerAddr(), requestBody, 1000L);
                for (MessageQueue mq : lockOKMQSet) {
                    processQueue = (ProcessQueue)this.processQueueTable.get(mq);
                    if (processQueue == null) continue;
                    if (!processQueue.isLocked()) {
                        log.info("the message queue locked OK, Group: {} {}", (Object)this.consumerGroup, (Object)mq);
                    }
                    processQueue.setLocked(true);
                    processQueue.setLastLockTimestamp(System.currentTimeMillis());
                }
                for (MessageQueue mq : mqs) {
                    if (lockOKMQSet.contains(mq) || (processQueue = (ProcessQueue)this.processQueueTable.get(mq)) == null) continue;
                    processQueue.setLocked(false);
                    log.warn("the message queue locked Failed, Group: {} {}", (Object)this.consumerGroup, (Object)mq);
                }
            }
            catch (Exception e) {
                log.error("lockBatchMQ exception, " + mqs, e);
            }
        }
    }

    public void doRebalance(boolean isOrder) {
        ConcurrentMap<String, SubscriptionData> subTable = this.getSubscriptionInner();
        if (subTable != null) {
            for (Map.Entry entry : subTable.entrySet()) {
                String topic = (String)entry.getKey();
                try {
                    this.rebalanceByTopic(topic, isOrder);
                }
                catch (Throwable e) {
                    if (topic.startsWith("%RETRY%")) continue;
                    log.warn("rebalanceByTopic Exception", e);
                }
            }
        }
        this.truncateMessageQueueNotMyTopic();
    }

    public ConcurrentMap<String, SubscriptionData> getSubscriptionInner() {
        return this.subscriptionInner;
    }

    private void rebalanceByTopic(String topic, boolean isOrder) {
        switch (this.messageModel) {
            case BROADCASTING: {
                Set mqSet = (Set)this.topicSubscribeInfoTable.get(topic);
                if (mqSet != null) {
                    boolean changed = this.updateProcessQueueTableInRebalance(topic, mqSet, isOrder);
                    if (!changed) break;
                    this.messageQueueChanged(topic, mqSet, mqSet);
                    log.info("messageQueueChanged {} {} {} {}", this.consumerGroup, topic, mqSet, mqSet);
                    break;
                }
                log.warn("doRebalance, {}, but the topic[{}] not exist.", (Object)this.consumerGroup, (Object)topic);
                break;
            }
            case CLUSTERING: {
                boolean changed;
                Set mqSet = (Set)this.topicSubscribeInfoTable.get(topic);
                List<String> cidAll = this.mQClientFactory.findConsumerIdList(topic, this.consumerGroup);
                if (null == mqSet && !topic.startsWith("%RETRY%")) {
                    log.warn("doRebalance, {}, but the topic[{}] not exist.", (Object)this.consumerGroup, (Object)topic);
                }
                if (null == cidAll) {
                    log.warn("doRebalance, {} {}, get consumer id list failed", (Object)this.consumerGroup, (Object)topic);
                }
                if (mqSet == null || cidAll == null) break;
                ArrayList<MessageQueue> mqAll = new ArrayList<MessageQueue>();
                mqAll.addAll(mqSet);
                Collections.sort(mqAll);
                Collections.sort(cidAll);
                AllocateMessageQueueStrategy strategy = this.allocateMessageQueueStrategy;
                List<MessageQueue> allocateResult = null;
                try {
                    allocateResult = strategy.allocate(this.consumerGroup, this.mQClientFactory.getClientId(), mqAll, cidAll);
                }
                catch (Throwable e) {
                    log.error("AllocateMessageQueueStrategy.allocate Exception. allocateMessageQueueStrategyName={}", (Object)strategy.getName(), (Object)e);
                    return;
                }
                HashSet<MessageQueue> allocateResultSet = new HashSet<MessageQueue>();
                if (allocateResult != null) {
                    allocateResultSet.addAll(allocateResult);
                }
                if (!(changed = this.updateProcessQueueTableInRebalance(topic, allocateResultSet, isOrder))) break;
                log.info("rebalanced result changed. allocateMessageQueueStrategyName={}, group={}, topic={}, clientId={}, mqAllSize={}, cidAllSize={}, rebalanceResultSize={}, rebalanceResultSet={}", strategy.getName(), this.consumerGroup, topic, this.mQClientFactory.getClientId(), mqSet.size(), cidAll.size(), allocateResultSet.size(), allocateResultSet);
                this.messageQueueChanged(topic, mqSet, allocateResultSet);
                break;
            }
        }
    }

    private void truncateMessageQueueNotMyTopic() {
        ConcurrentMap<String, SubscriptionData> subTable = this.getSubscriptionInner();
        for (MessageQueue mq : this.processQueueTable.keySet()) {
            ProcessQueue pq;
            if (subTable.containsKey(mq.getTopic()) || (pq = (ProcessQueue)this.processQueueTable.remove(mq)) == null) continue;
            pq.setDropped(true);
            log.info("doRebalance, {}, truncateMessageQueueNotMyTopic remove unnecessary mq, {}", (Object)this.consumerGroup, (Object)mq);
        }
    }

    private boolean updateProcessQueueTableInRebalance(String topic, Set<MessageQueue> mqSet, boolean isOrder) {
        boolean changed = false;
        Iterator it = this.processQueueTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            MessageQueue mq = (MessageQueue)next.getKey();
            ProcessQueue pq = (ProcessQueue)next.getValue();
            if (!mq.getTopic().equals(topic)) continue;
            if (!mqSet.contains(mq)) {
                pq.setDropped(true);
                if (!this.removeUnnecessaryMessageQueue(mq, pq)) continue;
                it.remove();
                changed = true;
                log.info("doRebalance, {}, remove unnecessary mq, {}", (Object)this.consumerGroup, (Object)mq);
                continue;
            }
            if (!pq.isPullExpired()) continue;
            switch (this.consumeType()) {
                case CONSUME_ACTIVELY: {
                    break;
                }
                case CONSUME_PASSIVELY: {
                    pq.setDropped(true);
                    if (!this.removeUnnecessaryMessageQueue(mq, pq)) break;
                    it.remove();
                    changed = true;
                    log.error("[BUG]doRebalance, {}, remove unnecessary mq, {}, because pull is pause, so try to fixed it", (Object)this.consumerGroup, (Object)mq);
                    break;
                }
            }
        }
        ArrayList<PullRequest> pullRequestList = new ArrayList<PullRequest>();
        for (MessageQueue mq : mqSet) {
            if (this.processQueueTable.containsKey(mq)) continue;
            if (isOrder && !this.lock(mq)) {
                log.warn("doRebalance, {}, add a new mq failed, {}, because lock failed", (Object)this.consumerGroup, (Object)mq);
                continue;
            }
            this.removeDirtyOffset(mq);
            ProcessQueue pq = new ProcessQueue();
            long nextOffset = -1L;
            try {
                nextOffset = this.computePullFromWhereWithException(mq);
            }
            catch (Exception e) {
                log.info("doRebalance, {}, compute offset failed, {}", (Object)this.consumerGroup, (Object)mq);
                continue;
            }
            if (nextOffset >= 0L) {
                ProcessQueue pre = this.processQueueTable.putIfAbsent(mq, pq);
                if (pre != null) {
                    log.info("doRebalance, {}, mq already exists, {}", (Object)this.consumerGroup, (Object)mq);
                    continue;
                }
                log.info("doRebalance, {}, add a new mq, {}", (Object)this.consumerGroup, (Object)mq);
                PullRequest pullRequest = new PullRequest();
                pullRequest.setConsumerGroup(this.consumerGroup);
                pullRequest.setNextOffset(nextOffset);
                pullRequest.setMessageQueue(mq);
                pullRequest.setProcessQueue(pq);
                pullRequestList.add(pullRequest);
                changed = true;
                continue;
            }
            log.warn("doRebalance, {}, add new mq failed, {}", (Object)this.consumerGroup, (Object)mq);
        }
        this.dispatchPullRequest(pullRequestList);
        return changed;
    }

    public abstract void messageQueueChanged(String var1, Set<MessageQueue> var2, Set<MessageQueue> var3);

    public abstract boolean removeUnnecessaryMessageQueue(MessageQueue var1, ProcessQueue var2);

    public abstract ConsumeType consumeType();

    public abstract void removeDirtyOffset(MessageQueue var1);

    @Deprecated
    public abstract long computePullFromWhere(MessageQueue var1);

    public abstract long computePullFromWhereWithException(MessageQueue var1) throws MQClientException;

    public abstract void dispatchPullRequest(List<PullRequest> var1);

    public void removeProcessQueue(MessageQueue mq) {
        ProcessQueue prev = (ProcessQueue)this.processQueueTable.remove(mq);
        if (prev != null) {
            boolean droped = prev.isDropped();
            prev.setDropped(true);
            this.removeUnnecessaryMessageQueue(mq, prev);
            log.info("Fix Offset, {}, remove unnecessary mq, {} Droped: {}", this.consumerGroup, mq, droped);
        }
    }

    public ConcurrentMap<MessageQueue, ProcessQueue> getProcessQueueTable() {
        return this.processQueueTable;
    }

    public ConcurrentMap<String, Set<MessageQueue>> getTopicSubscribeInfoTable() {
        return this.topicSubscribeInfoTable;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public MessageModel getMessageModel() {
        return this.messageModel;
    }

    public void setMessageModel(MessageModel messageModel) {
        this.messageModel = messageModel;
    }

    public AllocateMessageQueueStrategy getAllocateMessageQueueStrategy() {
        return this.allocateMessageQueueStrategy;
    }

    public void setAllocateMessageQueueStrategy(AllocateMessageQueueStrategy allocateMessageQueueStrategy) {
        this.allocateMessageQueueStrategy = allocateMessageQueueStrategy;
    }

    public MQClientInstance getmQClientFactory() {
        return this.mQClientFactory;
    }

    public void setmQClientFactory(MQClientInstance mQClientFactory) {
        this.mQClientFactory = mQClientFactory;
    }

    public void destroy() {
        for (Map.Entry next : this.processQueueTable.entrySet()) {
            ((ProcessQueue)next.getValue()).setDropped(true);
        }
        this.processQueueTable.clear();
    }
}

