/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.acl.common;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.acl.common.AclException;
import org.apache.rocketmq.acl.plain.PlainAccessResource;

public class Permission {
    public static final byte DENY = 1;
    public static final byte ANY = 2;
    public static final byte PUB = 4;
    public static final byte SUB = 8;
    public static final Set<Integer> ADMIN_CODE = new HashSet<Integer>();

    public static boolean checkPermission(byte neededPerm, byte ownedPerm) {
        if ((ownedPerm & 1) > 0) {
            return false;
        }
        if ((neededPerm & 2) > 0) {
            return (ownedPerm & 4) > 0 || (ownedPerm & 8) > 0;
        }
        return (neededPerm & ownedPerm) > 0;
    }

    public static byte parsePermFromString(String permString) {
        if (permString == null) {
            return 1;
        }
        switch (permString.trim()) {
            case "PUB": {
                return 4;
            }
            case "SUB": {
                return 8;
            }
            case "PUB|SUB": 
            case "SUB|PUB": {
                return 12;
            }
            case "DENY": {
                return 1;
            }
        }
        return 1;
    }

    public static void parseResourcePerms(PlainAccessResource plainAccessResource, Boolean isTopic, List<String> resources) {
        if (resources == null || resources.isEmpty()) {
            return;
        }
        for (String resource : resources) {
            String[] items = StringUtils.split(resource, "=");
            if (items.length == 2) {
                plainAccessResource.addResourceAndPerm(isTopic != false ? items[0].trim() : PlainAccessResource.getRetryTopic(items[0].trim()), Permission.parsePermFromString(items[1].trim()));
                continue;
            }
            throw new AclException(String.format("Parse resource permission failed for %s:%s", isTopic != false ? "topic" : "group", resource));
        }
    }

    public static void checkResourcePerms(List<String> resources) {
        if (resources == null || resources.isEmpty()) {
            return;
        }
        for (String resource : resources) {
            String[] items = StringUtils.split(resource, "=");
            if (items.length != 2) {
                throw new AclException(String.format("Parse Resource format error for %s.\nThe expected resource format is 'Res=Perm'. For example: topicA=SUB", resource));
            }
            if ("DENY".equals(items[1].trim()) || 1 != Permission.parsePermFromString(items[1].trim())) continue;
            throw new AclException(String.format("Parse resource permission error for %s.\nThe expected permissions are 'SUB' or 'PUB' or 'SUB|PUB' or 'PUB|SUB'.", resource));
        }
    }

    public static boolean needAdminPerm(Integer code) {
        return ADMIN_CODE.contains(code);
    }

    static {
        ADMIN_CODE.add(17);
        ADMIN_CODE.add(25);
        ADMIN_CODE.add(215);
        ADMIN_CODE.add(200);
        ADMIN_CODE.add(207);
    }
}

