/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger.store;

import io.openmessaging.storage.dledger.DLedgerConfig;
import io.openmessaging.storage.dledger.MemberState;
import io.openmessaging.storage.dledger.entry.DLedgerEntry;
import io.openmessaging.storage.dledger.protocol.DLedgerResponseCode;
import io.openmessaging.storage.dledger.store.DLedgerStore;
import io.openmessaging.storage.dledger.utils.PreConditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLedgerMemoryStore
extends DLedgerStore {
    private static Logger logger = LoggerFactory.getLogger(DLedgerMemoryStore.class);
    private long ledgerBeginIndex = -1L;
    private long ledgerEndIndex = -1L;
    private long committedIndex = -1L;
    private long ledgerEndTerm;
    private Map<Long, DLedgerEntry> cachedEntries = new ConcurrentHashMap<Long, DLedgerEntry>();
    private DLedgerConfig dLedgerConfig;
    private MemberState memberState;

    public DLedgerMemoryStore(DLedgerConfig dLedgerConfig, MemberState memberState) {
        this.dLedgerConfig = dLedgerConfig;
        this.memberState = memberState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DLedgerEntry appendAsLeader(DLedgerEntry entry) {
        PreConditions.check(this.memberState.isLeader(), DLedgerResponseCode.NOT_LEADER);
        MemberState memberState = this.memberState;
        synchronized (memberState) {
            PreConditions.check(this.memberState.isLeader(), DLedgerResponseCode.NOT_LEADER);
            PreConditions.check(this.memberState.getTransferee() == null, DLedgerResponseCode.LEADER_TRANSFERRING);
            ++this.ledgerEndIndex;
            ++this.committedIndex;
            this.ledgerEndTerm = this.memberState.currTerm();
            entry.setIndex(this.ledgerEndIndex);
            entry.setTerm(this.memberState.currTerm());
            if (logger.isDebugEnabled()) {
                logger.debug("[{}] Append as Leader {} {}", this.memberState.getSelfId(), entry.getIndex(), entry.getBody().length);
            }
            this.cachedEntries.put(entry.getIndex(), entry);
            if (this.ledgerBeginIndex == -1L) {
                this.ledgerBeginIndex = this.ledgerEndIndex;
            }
            this.updateLedgerEndIndexAndTerm();
            return entry;
        }
    }

    @Override
    public long truncate(DLedgerEntry entry, long leaderTerm, String leaderId) {
        return this.appendAsFollower(entry, leaderTerm, leaderId).getIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DLedgerEntry appendAsFollower(DLedgerEntry entry, long leaderTerm, String leaderId) {
        PreConditions.check(this.memberState.isFollower(), DLedgerResponseCode.NOT_FOLLOWER);
        MemberState memberState = this.memberState;
        synchronized (memberState) {
            PreConditions.check(this.memberState.isFollower(), DLedgerResponseCode.NOT_FOLLOWER);
            PreConditions.check(leaderTerm == this.memberState.currTerm(), DLedgerResponseCode.INCONSISTENT_TERM);
            PreConditions.check(leaderId.equals(this.memberState.getLeaderId()), DLedgerResponseCode.INCONSISTENT_LEADER);
            if (logger.isDebugEnabled()) {
                logger.debug("[{}] Append as Follower {} {}", this.memberState.getSelfId(), entry.getIndex(), entry.getBody().length);
            }
            this.ledgerEndTerm = entry.getTerm();
            this.ledgerEndIndex = entry.getIndex();
            this.committedIndex = entry.getIndex();
            this.cachedEntries.put(entry.getIndex(), entry);
            if (this.ledgerBeginIndex == -1L) {
                this.ledgerBeginIndex = this.ledgerEndIndex;
            }
            this.updateLedgerEndIndexAndTerm();
            return entry;
        }
    }

    @Override
    public DLedgerEntry get(Long index) {
        return this.cachedEntries.get(index);
    }

    @Override
    public long getLedgerEndIndex() {
        return this.ledgerEndIndex;
    }

    @Override
    public long getLedgerBeginIndex() {
        return this.ledgerBeginIndex;
    }

    @Override
    public long getCommittedIndex() {
        return this.committedIndex;
    }

    @Override
    public long getLedgerEndTerm() {
        return this.ledgerEndTerm;
    }
}

