/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger.cmdline;

import com.alibaba.fastjson.JSON;
import com.beust.jcommander.Parameter;
import io.openmessaging.storage.dledger.cmdline.BaseCommand;
import io.openmessaging.storage.dledger.entry.DLedgerEntry;
import io.openmessaging.storage.dledger.entry.DLedgerEntryCoder;
import io.openmessaging.storage.dledger.store.file.MmapFile;
import io.openmessaging.storage.dledger.store.file.MmapFileList;
import io.openmessaging.storage.dledger.store.file.SelectMmapBufferResult;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadFileCommand
extends BaseCommand {
    private static Logger logger = LoggerFactory.getLogger(ReadFileCommand.class);
    @Parameter(names={"--dir", "-d"}, description="the data dir")
    private String dataDir = null;
    @Parameter(names={"--pos", "-p"}, description="the start pos")
    private long pos = 0L;
    @Parameter(names={"--size", "-s"}, description="the file size")
    private int size = -1;
    @Parameter(names={"--index", "-i"}, description="the index")
    private long index = -1L;
    @Parameter(names={"--body", "-b"}, description="if read the body")
    private boolean readBody = false;

    @Override
    public void doCommand() {
        if (this.index != -1L) {
            this.pos = this.index * 32L;
            if (this.size == -1) {
                this.size = 0x2000000;
            }
        } else if (this.size == -1) {
            this.size = 0x40000000;
        }
        MmapFileList mmapFileList = new MmapFileList(this.dataDir, this.size);
        mmapFileList.load();
        MmapFile mmapFile = mmapFileList.findMappedFileByOffset(this.pos);
        if (mmapFile == null) {
            logger.info("Cannot find the file");
            return;
        }
        SelectMmapBufferResult result = mmapFile.selectMappedBuffer((int)(this.pos % (long)this.size));
        ByteBuffer buffer = result.getByteBuffer();
        if (this.index != -1L) {
            logger.info("magic={} pos={} size={} index={} term={}", buffer.getInt(), buffer.getLong(), buffer.getInt(), buffer.getLong(), buffer.getLong());
        } else {
            DLedgerEntry entry = DLedgerEntryCoder.decode(buffer, this.readBody);
            logger.info(JSON.toJSONString(entry));
        }
    }
}

