# CVE-2023-32353 Proof of Concept


## Disclaimer
 - This proof of concept code is published for educational purposes. 
 - It should encourage other people to find similar vulnerabilities, report them responsibly and fix them.
 - On May 23, 2023, Apple has published a fix for the vulnerability. 
 - You are encouraged to update iTunes to the latest version (at least 12.12.9). 
 - I did not find this CVE, I just did this PoC. Read the "Credits" section.
 - Neither I, nor this repo are affiliated with Apple.
 - The applicability of this PoC (proof of concept) is limited. You can read more about this in the Q&A section.

 
## TL;DR
The MSI installer of the music player Apple iTunes contained a vulnerability that allowed a regular, low-privileged user on a Microsoft Windows Computer to gain elevated permissions in the context of NT AUTHORITY/SYSTEM. This repo contains a proof of concept (PoC) to show how this could be exploited, as well as more information for security researchers and developers that want to learn more about this type of vulnerability. However, the applicability of this is limited as you can read in the Q&A section.


## Credits
- Zeeshan Shaikh from Synopsys has discovered CVE-2023-32353 and [published a post about it](https://www.synopsys.com/blogs/software-security/cyrc-vulnerability-advisory-cve-2023-32353/). This repo only contains a detailed proof of concept which goes beyond just the info that this vulnerability exists.
- The "CommonUtils" folder of this repo is used under license, which you can read in the LICENSE.txt in that folder.
- Code to find the latest "amd64_microsoft.windows.common-controls..." folder was adapted from the original code found in [binderlabs/DirCreate2System](https://github.com/binderlabs/DirCreate2System).


## How to run the PoC
- Install iTunes before version 12.12.9 (e.g. 12.12.4.1)
- Open the .sln file in Visual Studio 2019.
- Build the project using the "Release x64" configuration.
- Open the ./x64/Release/ directory
- Place a DLL of your choice inside of that directory with the name of "comctl32.dll". (You can use a similar one to the one used from [binderlabs/DirCreate2System](https://github.com/binderlabs/DirCreate2System/tree/main/bin), just rename "spawn.dll" to "comctl32.dll" - I am not responsible for the content of that repo. As always, be careful and build your own DLLs!)
- Run Privilege-Escalation-using-Music-Player.exe from that directory
- When the MSI installer asks you if you want to reboot now, choose "No"
- Now you should get a SYSTEM shell (if not, read the Q&A)


## Q&A

**I did not get a SYSTEM shell. What did I do wrong?**

Since this is a proof of concept, not many thoughts were made about being undetecable. To use this, you should run an Installation of Windows 10 HOME Edition before release 'Version 10.0.19041.572', because in that version, this vulnerability got patched. I did my testing using Windows 10 1909. Also, you should navigate to "Windows Security" and disable everything related to Microsoft Defender/Windows Defender, since they seem to block the symlink creation to \RPC Control using Real Time Protection (which gets turned on automatically on every restart again, remember that!)


**Should I be scared of using iTunes now?**

No, just update to the latest version of iTunes and you should be fine.


**Can I run the PoC without needing to build it on my own?**

While I strongly encourage everyone not to run any .exe files from the internet, running the Privilege-Escalation-using-Music-Player.exe from the ./x64/Release/ directory in a virtual machine should work. If not, you should try installing the latest VC redistributable from the [links provided by Microsoft](https://learn.microsoft.com/en-us/cpp/windows/latest-supported-vc-redist?view=msvc-170).


**What is the actual vulnerability here?**

During the MSI repair, the installer creates low-privileged folder called "SC Info" inside of C:\ProgramData\Apple Computer\iTunes\. To be precise, the directory C:\ProgramData\Apple Computer\iTunes does not allow everyone Full control. But the subfolder called "SC Info" gives Everyone (including low-privileged/standard users) Full control. If you manually delete all the contents of the C:\ProgramData\Apple Computer\iTunes\ folder (depending on whether you've ran iTunes before there might be more folders than just "SC Info"), then a low-privileged user is able to create a mount point from C:\ProgramData\Apple Computer\iTunes\ to any other directory that is writable by NT AUTHORITY/SYSTEM. In this proof of concept, the "wermgr.exe.local"-technique was used, which is already mitigated in current versions of Windows 10 and does only apply to the Windows 10 HOME edition as far as I know. So if you create a mount point from C:\ProgramData\Apple Computer\iTunes\ to \RPC Control and then a symlink from \RPC Control\SC Info (remember, SC Info is the name of the folder that the installer creates inside of the iTunes folder) to \??\c:\windows\system32\wermgr.exe.local and then use the MSI repair option of the iTunes installer, you effectively create a directory called wermgr.exe.local inside of C:\Windows\System32 which grants Full control to Everyone. This will effectively redirect the SC Info folder creation to \RPC Control, and RPC Control itself will redirect the folder creation to the System32 directory. From there on (again I tell you, this is not part of the actual vulnerability, but just to finish the privilege escalation vulnerability chain), you can create a specifically named subfolder with a crafted DLL in there which a service that will run as NT AUTHORITY/SYSTEM, even when called using a scheduled task by a low-privileged user, will load and execute the commands in there. (e.g. a cmd running as NT AUTHORITY/SYSTEM) For more details, please refer to the actual code or to the "Steps to manually reproduce" section below.


## Learn more about the technique used in this PoC
- "[An introduction to privileged file operation abuse on Windows](https://offsec.almond.consulting/intro-to-file-operation-abuse-on-Windows.html)" by Almond
- "[bugzzzhunter/Folder-Deletion-to-System-Shell](https://github.com/bugzzzhunter/Folder-Deletion-to-System-Shell)" 
- "[binderlabs/DirCreate2System](https://github.com/binderlabs/DirCreate2System)"


## Steps to manually reproduce:
- Since this is a Proof of Concept, turn off Windows Defender/Microsoft Defender (also, read Q&A section)

- Install iTunes before version 12.12.9 (e.g. 12.12.4.1)

- Delete all contents of C:\ProgramData\Apple Computer\iTunes, but keep the iTunes folder itself

- Create a Mount Point from "C:\ProgramData\Apple Computer\iTunes" to "\RPC Control", e.g. using James Forshaw's [symboliclink-testing-tools](https://github.com/googleprojectzero/symboliclink-testing-tools):

    CreateMountPoint.exe "C:\ProgramData\Apple Computer\iTunes" "\RPC Control"

- Create a Symlink from "\RPC Control\SC Info" to "\??\c:\windows\system32\wermgr.exe.local"

    CreateDosDeviceSymlink.exe "\RPC Control\SC Info" "\??\c:\windows\system32\wermgr.exe.local"

- Using the iTunes MSI/iTunes Installer EXE, "repair" your installation of iTunes (if you don't have the Installer anymore, you can locate "iTunes64.msi" in this folder: C:\ProgramData\Apple Computer\Installer Cache\iTunes <version>\)

- Navigate to c:\windows\system32\wermgr.exe.local\

- Create a subfolder called "amd64_microsoft.windows.common-controls_6595b64144ccf1df_6.0.18362.418_none_e6c6b287130d565d" (this can be different on your system, use the name of the latest folder starting with "amd64_microsoft.windows.common-controls_" from the C:\Windows\WinSxS\ directory)

- Put a DLL file named "comctl32.dll" inside the amd64_microsoft.windows.common-controls_* folder

- Run this command:

    schtasks.exe /Run /TN "\Microsoft\Windows\Windows Error Reporting\QueueReporting"

- The action you specified inside your comctl32.dll file will now be executed in the context of NT AUTHORITY/SYSTEM, e.g. a cmd window opens