# CVE-2023-30861 PoC (Proof of Concept)

> ⚠️ **주의 (CAUTION)**  
> 이 프로젝트는 Flask의 CVE-2023-30861 취약점을 재현하기 위한 목적의 PoC입니다.  
> **절대로 인터넷에 노출된 환경에서 실행하지 마세요.**  
> 외부 접근이 가능한 네트워크에 연결되면 실제 공격에 악용될 수 있습니다.

> ⚠️ **WARNING**  
> This project is a Proof of Concept (PoC) for demonstrating CVE-2023-30861 in Flask.  
> **Do NOT run this on a publicly accessible environment.**  
> Exposure to the internet may lead to real-world exploitation.

---

## 📦 프로젝트 개요 (Project Overview)

Flask와 reverse proxy 캐시 서버 간의 세션 처리 오류로 인해 발생하는 보안 취약점을 테스트하는 환경을 제공합니다.  
Docker 기반의 로컬 환경에서 안전하게 재현하세요.

This PoC sets up a safe, local Docker environment to reproduce a vulnerability caused by improper session handling between Flask and a reverse proxy cache server.


## 🚀 사용법 (How to Use)

### 1. 실행 (Start)

```bash
chmod u+x ./app_build.sh
./app_build.sh
```

### 2. 종료 및 정리 (Stop & Clean)

``` bash
docker compose rm -f
docker image prune -a
```

## 🧪 API 테스트 (API Testing)

HTTP 요청 예시는 `test.http` 파일을 참고하세요.

Use the `test.http` file to test and validate the PoC behavior using REST clients like VS Code REST Client or Postman.

## ✅ 권장 실행 환경 (Recommended Execution Environment)

Docker & Docker Compose

Linux/MacOS (or WSL2 for Windows)

Local-only network (no public IP or domain exposed)

## 💡 참고 (Note)

이 PoC는 학습 및 분석 목적이며, 어떤 공격에도 사용해서는 안 됩니다.
This PoC is for educational and security research purposes only.
Do not use it for malicious activities.
