#!/bin/bash

echo "Digite a URL que deseja escanear:"
read alvo

# Executar Subfinder para encontrar subdomínios
subfinder -d "$alvo" -silent | dnsx -silent -asn | cut -d ' ' -f1 | grep --color 'api' > subdominios.txt

# Verificar se o arquivo subdominios.txt existe e não está vazio
if [ -s subdominios.txt ]; then
  echo "Subdomínios com 'api' encontrados:"
  cat subdominios.txt
  echo
  echo "Realizando solicitações HTTP POST nos subdomínios..."
  while read -r url; do
    # Usar o curl para fazer uma solicitação HTTP POST para a URL com a estrutura correta
    curl "$url/api" -X POST -H 'X-HTTP-Method-Override: POST' -H 'Content-Type: application/json' --data '{"username":"xyz"}'
    # Adicionar um espaço em branco para separar as saídas
    echo
  done < subdominios.txt
else
  echo "Nenhum subdomínio com 'api' encontrado."
fi

# Remover o arquivo de subdomínios temporário
rm subdominios.txt
