# CVE-2023-30486
Square &lt;= 2.0.0 - Missing Authorization via activate_plugin

# Description
  
The Square theme for WordPress is vulnerable to unauthorized plugin activation due to a missing capability check on the activate_plugin function called via an AJAX action in versions up to, and including, 2.0.0. This makes it possible for authenticated attackers , with subscriber-level access and above, to activate arbitrary plugins.


```
Missing Authorization
CVSS Vector
CVSS:3.1/AV:N/AC:L/PR:L/UI:N/S:U/C:N/I:L/A:N
CVE 	CVE-2023-30486
CVSS 	4.3 (Medium)
Publicly Published 	April 13, 2023
Last Updated 	January 22, 2024
Researcher 	Dave Jong - Patchstack
```

Links
---

https://patchstack.com/database/vulnerability/square/wordpress-square-theme-2-0-0-broken-access-control


https://themes.trac.wordpress.org/changeset?sfp_email=&sfph_mail=&reponame=&old=177729%40square&new=177729%40square&sfp_email=&sfph_mail=

POC
---

```
$ python3 CVE-2023-30486.py -u http://kubernetes.docker.internal -un user -p user
Logged in successfully.
hashthemes-demo-importe installed
```

Notes
---
Pointless CVE but i thought it would be fun to do a POC seems to only work if the hashthemes-demo-importer has never been installed before.
