# mRemoteNG <= v1.77.3.1784-NB Password Dumper ([CVE-2023-30367](https://nvd.nist.gov/vuln/detail/CVE-2023-30367))

Multi-Remote Next Generation Connection Manager (mRemoteNG) is free software that enables users to store and manage multi-protocol connection configurations to remotely connect to systems.

mRemoteNG configuration files can be stored in an encrypted state on disk. mRemoteNG version <= v1.76.20 and <= 1.77.3-dev loads configuration files in plain text into memory (after decrypting them if necessary) at application start-up, even if no connection has been established yet. This allows attackers to access contents of configuration files in plain text through a memory dump and thus compromise user credentials when no custom password encryption key has been set. This also bypasses the connection configuration file encryption setting by dumping already decrypted configurations from memory.

This vulnerability was assigned [CVE-2023-30367](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2023-30367).
Tested with `mRemoteNG 1.77.3.1784-NB` and `mRemoteNG 1.76.20` on Windows 11 (German).

Finding was confirmed by Dimitrij Gorodeckij, one of mRemoteNG's developers, [here](https://github.com/mRemoteNG/mRemoteNG/issues/2420). A fix is still in development. Thanks again to Dimitrij Gorodeckij for his fast response and cooperation!  Hopefully it will be fixed soon!


### What can you do
**1. Use strong (long) configuration password encryption passwords/keys:** 
In case of a memory dump an attacker would gain access to configuration files in plaintext but would still have to bruteforce the passwords encryption key.
Unfortunately, `enabling the Connection file encryption option doesn't help in preventing this attack` since mRemoteNG connection configuration files get decrypted at runtime.

**2. Update to mRemoteNG greater than v1.77.3.1784-NB when a fix has been released.**

**3. To prevent malicious execution of e.g. mRemoteNGDumper.exe, application whitelisting should be enforced.**

### Note
Please be aware that configuration password encryption and connection file encryption are different settings. Configuration password encryption is used to encrypt the password within the configuration file only while connection file encryption is used to encrypt the whole configuration file itself.
This exploit bypasses the connection file encryption by dumping already decrypted configurations from memory. These still contain encrypted passwords which can be decrypted with default key `mR3m`. If a custom configuration password encryption key/password has been set, an attacker would still have to guess the custom key. (See [mremoteng-decrypt.py section](#mremoteng_decryptpy))


## Setup
1. [Install .NET](https://dotnet.microsoft.com/en-us/download) (most major operating systems supported).
2. Clone the repository: `git clone https://github.com/S1lkys/CVE-2023-30367-mRemoteNG-password-dumper.git` or download it from GitHub
2. Enter the project directory `mRemoteNG-password-dumper`
3. Open solution with VisualStudio and build using .Net 4.8.1

The easiest way to manually test this on Windows is to create a process dump using the windows task manager by right-clicking the mRemoteNG process and selecting "Create dump file".
The dump can be opened in VisualStudio Code. Search then for your configured connection values.

## Manual Proof of Concept
  1) Create a new connection configuration, set hostname, username and password.
  2) Enable disk file encryption for configuration files.
  3) Restart mRemoteNG
  4) Use Task Manager / Processhacker / Procdump or any other tool that can create minidumps of a process to create a minidump.
  5) Examine the minidump file and search for "<Node Name=" which indicates the beginning of mRemoteNGs connection configuration file.

## mRemoteNGDumper.exe

mRemoteNG Password Dumper is a simple proof-of-concept tool used to dump configuration files from mremoteNG's memory. No code execution on the target system is required, just a memory dump.
It's a quick POC, so likely not very reliable and robust. Please create a pull request if you happen to find an issue and fix it.

Configuration files are currently hardcoded like this: `(\<Node)(.*)(?=\/>)\/>`
1. Start mRemoteNG and enter a file decryption password if needed.
2. Execute mRemoteNGDumper.exe in a terminalsession. Dumped configuration files are saved in a folder named "dump".
3. Decrypt/Bruteforce dumped files or password strings having custom passwords with `mremoteng_decrypt.py` (See [mremoteng-decrypt.py section](#mremoteng_decryptpy))

## mRemoteNG_Decrypt.py

I added a bruteforce functionality to mremoteng-decrypt (See acknowledgements).
This can be used to bruteforce custom mRemoteNG configuration/password encryption keys. If no custom key has been configured the script will decrypt the config with default key `mR3m`. This script can also be used to decrypt configuration files with custom encryption passwords. See also [Demo](#demo-watch-in-new-tab).

![mremoteng_decrypt](/assets/mremoteng_decrypt_and_bruteforce.png)

Decrypt configuration file with custom encryption password 123: `python3 mremoteng_decrypt.py -rf "C:\Users\mbzra\source\repos\mRemoteNG Dumper\dump\extracted_Configfile_mRemoteNG_0_09.07.2023.11.01_confCons.xml" -p 123`

Decrypt password string with custom encryption password 123: `python3 mremoteng_decrypt.py -s "QHrcb7I0KHi6YLFXxv93jenrUmNj5qO30zTM9qXqRUd7ImVm5/ROU7CLQ5u7+7+iOiFrY2BtZSpJ8RrR3jV6LoE=" -p 123`

Decrypt password string with no custom encryption password: `python3 mremoteng_decrypt.py -s "yW0Ypq/cTcwfHwYxIiHgczcsIKU+jWlfnZBcTdKQImsMbBnP3SLv2h75Z7IAbkFOsD2YzBo2wGk2fhDLpRFH2y8="`

Bruteforce usage: `python3 mremoteng_decrypt.py -s "[extracted encrypted configuration password]" -b y -w [path to wordlist]`

Bruteforce example: `python3 mremoteng_decrypt.py -s "QHrcb7I0KHi6YLFXxv93jenrUmNj5qO30zTM9qXqRUd7ImVm5/ROU7CLQ5u7+7+iOiFrY2BtZSpJ8RrR3jV6LoE=" -b y -w .\wordli.txt`



## Should You Be Worried?

Depends on your threat model. **If your computer is already infected by malware that's running in the background with the privileges of your user, this finding doesn't make your situation much worse.** However, it might be easier for the malware to be stealthy and evade the antivirus, since unlike KeeTheft or KeeFarce, no process injection or other type of code execution is necessary. 

If you have a reasonable suspicion that someone could obtain access to your computer and conduct forensic analysis, this could be bad.

If you use configuration file encryption with a strong password and your system is clean, you should be fine. No one can steal your passwords remotely over the internet with this finding alone. 


## Demo
![Demo](/assets/mRemoteNGDumper-demo.gif)

## Acknowledgements to related Projects
- [Python mRemoteNG Password decryptor](https://github.com/kmahyyg/mremoteng-decrypt) by [kmahyyg](https://github.com/kmahyyg) which I modified to add bruteforce functionality.
- [Keepass master password dumper](https://github.com/vdohney/keepass-password-dumper) by [vdohney](https://github.com/vdohney) where I stole this README.md from which I adjusted to my needs.


## References
- https://www.secuvera.de/advisories/secuvera-SA-2023-01.txt
- https://github.com/mRemoteNG/mRemoteNG/issues/2420
- https://cve.mitre.org/cgi-bin/cvename.cgi?name=2023-30367
- https://cwe.mitre.org/data/definitions/316.html
- https://www.first.org/cvss/calculator/3.1#CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:U/C:H/I:N/A:N
