# CVE-2023-27470 EoP via Arbirary File Deletion Exercise

This repository contains a local privilege escalation exercise that replicates CVE-2023-27470. Your mission, should you choose to accept it, find the vulnerability and get a SYSTEM Command Prompt! If you would like the jump to the solution, look at `solution.txt`. Read more about arbitrary file deletion vulnerabilities and its risks at [Deleting Your Way Into SYSTEM: Why Arbitrary File Deletion Vulnerabilities Matter].

Author: Andrew Oliveau (@AndrewOliveau)

## Exercise Set Up Instructions

1. Use a Windows VM configured with 2 processors and 2 cores per processor
2. Create `C:\ProgramData\logs` folder with elevated account and add `log.txt` into it
3. Run `CVE-2023-27470_Exercise.exe` with elevated account. If you see "Error opening directory: 3", that is OK. Consider it a hint...

Optional: Create a protected file and/or folder with elevated account to test file deletion 

Bonus: Run `CVE-2023-27470_Mitigated.exe` to test Microsoft's `ProcessRedirectionTrustPolicy` mitigation policy. 

## Building Yourself

Should you choose to compile it yourself, use the provided `CVE-2023-27470_Exercise.sln` Visual Studio project and make sure your are using Windows SDK version 10.0.20348.0.


[Deleting Your Way Into SYSTEM: Why Arbitrary File Deletion Vulnerabilities Matter]: https://www.mandiant.com/resources/blog/arbitrary-file-deletion-vulnerabilities
