#!/bin/bash
set -e

echo "[+] Waiting for Nextcloud to be ready..."
until docker-compose exec -T -u www-data app php occ status > /dev/null 2>&1; do
  echo -n "."
  sleep 2
done
echo " OK"

echo "[+] Installing and Enabling 'workflow_script' app..."
# We need to install the 'workflow_script' app. As it might not be in the default market or requires specific version compatibility,
# we attempt to install it via occ. If it fails, we might need to download it manually.
# For 25.0.3, it should be available.
docker-compose exec -T -u www-data app php occ app:install workflow_script || echo "Risk: App might not be found directly."
docker-compose exec -T -u www-data app php occ app:enable workflow_script

echo "[+] Creating attacker user..."
export OC_PASS="AttackerPassword123!"
docker-compose exec -T -e OC_PASS -u www-data app php occ user:add --password-from-env --display-name="Attacker" attacker

echo "[+] Done! You can now login as attacker/attacker."
