Next cloud
## Proof of Concept & Analysis

## Security Notice

This repository reproduces a publicly disclosed and patched vulnerability in a controlled Docker lab environment for educational and research purposes.

The environment is intentionally vulnerable and must only be deployed in isolated test environments. Do not attempt to exploit systems without explicit authorization.

The goal of this project is to demonstrate vulnerability analysis, exploitation workflow, and mitigation strategies.

This lab reproduces **CVE-2023-26482**, a Missing Scope Validation vulnerability in Nextcloud Server that allows an authenticated user to create malicious workflows, leading to Remote Code Execution (RCE) if the "Workflow Script" app is installed.


<img width="1024" height="559" alt="image" src="https://github.com/user-attachments/assets/07d6e935-076e-4976-af19-d72c9c615fdd" />

## Prerequisites

- Docker & Docker Compose
- Python 3
- `requests` library

## Setup

1.  **Start the environment:**
    ```bash
    docker-compose up -d
    ```


2.  **Configure the instance (Automated):**
    Run the setup script to install the vulnerable `workflow_script` app and create a test user 
    ```bash
    bash setup.sh
    ```
    *Note: This might take a few minutes as it waits for Nextcloud to fully initialization.*

3.  **Install Python dependencies:**
    ```bash
    pip install -r requirements.txt
    ```

## Exploitation

1.  **Run the exploit:**
    ```bash
    python exploit.py
    ```
    This script will:
    - Log in as `attacker`.
    - Create a Global/Admin workflow rule (which should be forbidden) to execute a command (`touch /tmp/pwned`) when a file with MIME type `text/plain` is uploaded.

2.  **Trigger the RCE:**
    - Log in to `http://localhost:8080` with `attacker` / `AttackerPassword123!`.
    - Upload a text file (e.g., `test.txt`).
    - The command should execute in the container.

## Verification

Check if the file `/tmp/pwned` exists in the container:

```bash
docker-compose exec app ls -l /tmp/pwned
```

## Demonstration 

Firstly let's begin with user credentials created for the lab, witheout admin permissions : 

<img width="931" height="807" alt="image" src="https://github.com/user-attachments/assets/18c5ae00-0675-4d4d-8cdb-c19716a349ba" />

As you can see overhere, the user attacker doesn't have admin permissions : 
<img width="1912" height="808" alt="image" src="https://github.com/user-attachments/assets/1e02cac4-c17c-4bfa-bf90-090bd0effb01" />

Let's start the exploit.py file : 

<img width="796" height="528" alt="image" src="https://github.com/user-attachments/assets/680bf2a4-5c05-43c0-ab1c-393f7466578f" />

As you can see here, we just have to upload a random .txt file

<img width="1888" height="948" alt="image" src="https://github.com/user-attachments/assets/72a2c43d-fafb-42c2-a600-d9261e3dc62a" />


Here we go ! : 

<img width="1288" height="117" alt="image" src="https://github.com/user-attachments/assets/45ae2d5d-a5cc-4b27-84b2-63844ecabc88" />


## Reference 
https://nvd.nist.gov/vuln/detail/cve-2023-26482?
https://app.opencve.io/cve/CVE-2023-26482?

This vulnerability (CVE-2023-26482) can be corrected by upgrading 
the Nextcloud Server to a fixed version (≥ 24.0.10 or ≥ 25.0.4). 


