# CVE-2023-25690
## Mô tả CVE-2023-25690:
- Một vài cấu hình mod_proxy trên Apache HTTP Server từ phiên bản 2.4.0 đến 2.4.55 cho phép tấn công HTTP Request Smuggling (kỹ thuật tấn công can thiệp vào quá trình trang web xử lý các chuỗi yêu cầu HTTP nhận được từ một hay nhiều người dùng).
- Các cấu hình này bị ảnh hưởng khi mod_proxy được bật cùng với một vài dạng RewireRule hoặc ProxyPassMatch trong đó kẻ tấn công từ xa có thể khai thác lỗ hổng này để qua mặt các biện pháp kiểm soát truy cập trong máy chủ proxy, do đó ủy quyền các URL không mong muốn cho máy chủ gốc
- Lỗ hổng này cho phép kẻ tấn công nhắm mục tiêu và truy cập các ứng dụng nội bộ được ẩn bởi proxy, có khả năng dẫn đến truy cập trái phép, rò rỉ dữ liệu hoặc khai thác sâu hơn vào hệ thống

# Thực nghiệm CVE-2023-25690
- Sử dụng máy windows làm máy tấn công
- Phần backend-server và proxy-server được triển khai thông qua Docker trên máy Kali Linux
  
## Cấu trúc file lab:
![image](https://github.com/thanhlam-attt/CVE-2023-25690/assets/79523444/f1db72a4-4ad5-43eb-b723-19063fa88391)

## Mô hình thực nghiệm
![image](https://github.com/thanhlam-attt/CVE-2023-25690/assets/79523444/6681abbc-af28-47b8-b437-090fc33811f1)
- Địa chỉ ip máy Widows 10: 192.168.1.177
- Địa chỉ ip máy Kali Linux: 192.168.27.139
- Địa chỉ ip Backend-Server: 172.18.0.2
- Địa chỉ ip Proxy-Server: 172.18.0.3
- Khi máy Windows 10 truy cập vào Apache HTTP Server được host trên máy Kali port 80 lưu lượng sẽ được forward tới port 80 tại Proxy-Server và chuyển tiếp tới Backend-Server thông qua port 8080  

## Yêu cầu hệ thống
- Máy tấn công:
  + Hệ điều hành Windows 10
  + Cài đặt các công cụ: Pycharm, BurpSuite, VScode
  + Sử dụng trình duyệt FireFox và cài extension FoxyProxy để cấu hình proxy
- Máy nạn nhân:
  + Cài đặt các công cụ và dịch vụ: Docker, Tcpdum
  + Cấu hình Docker File (xem phần phụ lục)
#### Mục tiêu khai thác: lợi dụng lỗ hổng HTTP Request Smuggling vượt qua hạn chế của proxy server và truy cập vào hàm ẩn trên trang admin.php

## Triển khai thực nghiệm:
- Sử dụng BurpSuite Community cấu hình thành proxy để chặn bắt và chỉnh sửa các request
- Tại browser tải extension FoxyProxy và thêm các thông tin về proxy:
  ![image](https://github.com/thanhlam-attt/CVE-2023-25690/assets/79523444/b2ae626e-2f60-42f8-81d9-6fc265a1448c)
- Bật FoxyProxy ở trên thanh công cụ (tại phần extension của trình duyệt) chuyển từ Turn Off sang BurpSuite Commu:  
  ![image](https://github.com/thanhlam-attt/CVE-2023-25690/assets/79523444/ecbdc22c-092b-4474-ad2c-95b7f37f552d)  
- Tại BurpSuite, bật intercept sang on để thực hiện chặn bắt gói tin:  
  ![image](https://github.com/thanhlam-attt/CVE-2023-25690/assets/79523444/870a2a44-1953-4b90-8300-320e0c6134aa)   
- Tại máy Kali, sử dụng câu lệnh *cd* di chuyển vào trong thư mục lab nơi chứa file docker-composer.yml và chạy docker composer với câu lệnh: *docker-composer up --build*
  
### Kiểm tra CRLF Injection:
- Đầu tiên, ta gửi một Request có chứa các ký tự điều khiển (CRLF) lên hệ thông như sau: HTTP/1.1\r\nFoo: 
baarr\r\r\n\n và encode URL thành: %20HTTP/1.1%0d%0aFoo:%20baarr  
  ![image](https://github.com/thanhlam-attt/CVE-2023-25690/assets/79523444/995912d6-c931-4390-aa94-45c26b1ed690)  
=> Có thể thấy rằng, khi ta chèn các ký tự CRLF (%0d%0a), server xử lý request của chúng ta mà không trả về bất cứ lỗi hoặc hạn chế nào cho thấy rằng chúng ta hoàn toàn có thể chèn vào các ký tự CRLF
### Kiểm tra HTTP Request Smuggling:
- Tiếp theo, ta có một URI như sau:
  /categories/1 HTTP/1.1\r\nHost: Localhost\r\n\r\nGET /SMUGGLED, tiếp tục encode URL ta được: /categories/1%20HTTP/1.1%0d%0aHost:%20localhost%0d%0a%0d%0aGET%20/SMUGGLED/  
  ![image](https://github.com/thanhlam-attt/CVE-2023-25690/assets/79523444/2caba2d5-d6fd-420f-9b7a-df0d9d79e5a7)  
- Sau khi áp dụng RewriteRule, có thể thấy rằng URL sẽ được phân tích cú pháp và request ta gửi lên sau khi đi qua proxy sẽ chuyển thành định dạng như sau:  
  ![image](https://github.com/thanhlam-attt/CVE-2023-25690/assets/79523444/30adbd9e-51a1-4397-ac94-8614298bb1aa)  
- Có thể thấy rằng, với một request ta gửi lên nhưng phía server nhận được và trả về tới tận 2 response, một là của GET /categories và một là của GET /SMUGGLED  
  ![image](https://github.com/thanhlam-attt/CVE-2023-25690/assets/79523444/492fdf68-7a5a-4245-9380-0287c0ee45a2)
### Khai thác HTTP Request Smuggling:
- Giả sử, trong file httpd.conf ta cấu hình Proxy-Server chặn không cho phép truy cập vào trang /admin/
  ![image](https://github.com/thanhlam-attt/CVE-2023-25690/assets/79523444/6f7631bb-d307-45c8-9423-62e05639448e)  
- Ta có thể tận dụng HTTP Request Smuggling để vượt qua cơ chế kiểm tra của apache-proxy với request:  
  ![image](https://github.com/thanhlam-attt/CVE-2023-25690/assets/79523444/f7e9422a-763d-4ff3-9733-11b5bc8aed6e)  
  + Kiểm tra log, ta nhận thấy rằng đã thành công vượt qua apache-proxy, gửi request tới /admin thành công và backend cũng trả về status code 200 đối với GET /admin  
    ![image](https://github.com/thanhlam-attt/CVE-2023-25690/assets/79523444/17444254-d06b-4118-8f95-9e574b70f602)
  + Giả sử, trong file admin.php có một hàm thực thi câu lệnh hệ thống nslookup để truy vấn tới một domain bất kỳ như sau, mục tiêu của chúng ta là vượt qua cơ chế của proxy và truy cập vào hàm ẩn này gửi truy vấn DNS
tới một domain bất kỳ, ở đây ta truy vấn tới chính máy Kali của chúng ta.  
    ![image](https://github.com/thanhlam-attt/CVE-2023-25690/assets/79523444/6e8a086c-e1a1-4a8e-8da0-6faa8f807ceb)
  + Ta có code khai thác (file CVE-2023-25690.py) - và file pre.txt (chứa request smuggled mà ta muốn bypass qua Proxy-Server để gửi request tới hệ thống, ở đây là /admin.php), đoạn code này sẽ tạo một request smuggling với request chúng ta muốn nằm trong file pre.txt và gửi nó về phía server. Đồng thời ghi lại kết quả request và response vào trong 2 file tương ứng là req.txt và res.txt  
    ![image](https://github.com/thanhlam-attt/CVE-2023-25690/assets/79523444/5c8b1cdd-b932-461f-9a19-7f028c745d28)  
  + Đồng thời tại máy kali sử dụng TCPDUMP để bắt các gói tin DNS tại port 53
    ![image](https://github.com/thanhlam-attt/CVE-2023-25690/assets/79523444/26404d90-050a-4ad6-a3bb-1ab36f24f457)
- Có thể thấy rằng, request ta gửi lên đã vượt qua được proxy, proxy cho rằng đây là một request hợp lệ. Nhưng tại backend-server, request được phân tích cú pháp cả những ký tự điều khiển nên từ một request, backend-server đã phân tích request đó thành 3 request, một là GET /categories.php?id=1, hai là GET /admin.php?secret=192.168.1.194 và cuối cùng là GET /abc  
  ![image](https://github.com/thanhlam-attt/CVE-2023-25690/assets/79523444/45bf7459-0cd6-4ae6-8c09-7ef48c0bc893)  
- Như vậy ta đã gửi thành công request tới /admin.php, nơi mà proxy không cho phép ta gửi request tới
  ![image](https://github.com/thanhlam-attt/CVE-2023-25690/assets/79523444/1ca1770b-378d-48d1-a4dc-27e465f24998)  
=> Kiểm tra TCPDUMP ta thấy rằng, TCPDUMP đã bắt được các gói tin DNS được gửi tới -> thực thi thành công hàm ẩn trong /admin.php

# Phụ lục
## Cấu hình file DockerFile trong folder Backend  
![image](https://github.com/thanhlam-attt/CVE-2023-25690/assets/79523444/624fb1fc-a4b2-4123-95ae-048ffe0b7d9e)  
- File cấu hình này chỉ định rằng, phía Backend-Server sử dụng image là PHP 7.4-apache, đây là một image chứa PHP 7.4 cùng với Web Server Apache
- Command thứ 2 sao chép tất cả nội dung từ thư mục src/ vào thư mục /var/www/html - Đây chính là thư mục mặc định để Apache sử dụng xây dựng nội dung web hay thư mục này còn gọi là web root
- Command thứ 3 sử dụng sed để thay thế tất cả các trường 80 thành 8080. Điều này cho phép thay đổi cổng mặc định của Apache bên Backend-Server từ 80 sang 8080.
- Command thứ 4 dùng để cập nhập các gói tin và cài đặt gói tin dnsutils - có thể xem thông tin về gói tin này tại đây https://github.com/iagox86/dnsutils/blob/master/README.md
- Và command cuối được thực thi khi container được chạy, đó là lệnh sử dụng apache để chạy Apache Web Server
## Cấu hình file DockerFile trong folder Frontend 
![image](https://github.com/thanhlam-attt/CVE-2023-25690/assets/79523444/0b49a30a-1da8-4b43-8d76-cbe3b4035bad)  
- File này sẽ copy file httpd.conf trong folder Frontend vafoo trong file /tmp/httd.conf và cuối cùng là đưa nội dung file httpd.conf đó vào trong file /usr/local/apache2/conf/httpd.conf
- File httpd.conf chính là file cấu hình chính của apache HTTP server, file này định nghĩa các cài đặt cấu hình hoặc các hoạt động trong server - ở đây là Proxy-Server
- File httpd.conf thường được cài đặt tại đường dẫn /usr/local/apache2/conf/httpd.conf vì vậy chúng ta phải đưa nội dung vào đường dẫn /usr/local/apache2/conf/httpd.conf còn việc tạo một file httpd.conf trong folder Frontend để có thể cấu hình apache một cách linh hoạt hơn (không cần phải cd vào tận đường dẫn trên để viết lại file httpd.conf)
## Cầu hình file docker-compose.yml:  
![image](https://github.com/thanhlam-attt/CVE-2023-25690/assets/79523444/b411678c-bd9f-4c12-a730-10af5c424eca)  
- Tại đây định nghĩa các service, network,... cần thiết để chạy ứng dụng
- Ở đây ta khai báo 2 services chính là apache-proxy và backend-server:
  + Apache-Proxy: được xây dựng dựa trên file ./frontend/DockerFile và network là backend-network (bridge) hơn nữa, còn cấu hình depends_on: backend-server để chỉ định rằng Apache-Proxy chỉ được khởi chạy sau khi khởi chạy xong Backend-Server. Cuối cùng là ports: "80:80" để chỉ định port forward, các lưu lượng tới port 80 trên máy host sẽ được chuyển tiếp tới port 80 của container
  + Backend-Server: được xây dựng dựa trên file ./backend/DockerFile với network là backend-network cùng với Proxy để chúng có thể giao tiếp được với nhau, cấu hình expose mở port 8080 để Apache-Proxy forward lưu lượng tới Backend-Server qua cổng này và cuối cùng là một số tính năng bảo mật như không cho phép user tạo quyền mới (thêm sửa xóa tệp, thêm các quyền với process hoặc network,...) và lọc các system call được thực hiện bởi một chương trình
## Cấu hình file httpd.conf
![image](https://github.com/thanhlam-attt/CVE-2023-25690/assets/79523444/5886da15-c03a-4a8d-adf7-e4dd7773c8c1)
- Đầu tiên là cấu hình lưu trữ log tại 2 đường dẫn là /use/local/apache2/logs/error.log và /use/local/apache2/logs/access.log
- Tiếp đến là load các module cần thiết để có thể áp dụng Rewrite Rule (Quy tắc ghi lại)
- Tiếp đến chỉ định DocumentRoot là file sẽ chỉ định tham số trong file cấu hình apache cho phép xác định các file dữ liệu của máy chủ được đặt ở đâu
- Tiếp theo là áp dụng luật ghi lại cho path tới /categories/ và /admin/
- Và cuối cùng là chặn không cho gửi request tới /admin/ -> Mục đích để chúng ta làm lab bypass qua proxy và truy cập tới trang này
