# CVE-2023-25157 - GeoServer SQL Injection - PoC 

- **CVE:** [CVE-2023-25157](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2023-25157)
- **Date:** 06/06/2023
- **Vendor/Software:** [GeoServer](https://github.com/geoserver/geoserver)
- **Severity:** 9.8/10 - ![Alt text](https://img.shields.io/badge/-Critical-red) 

This script is a proof of concept for OGC Filter SQL Injection vulnerabilities in GeoServer, a popular open-source software server for sharing geospatial data. It sends requests to the target URL and exploits potential vulnerabilities by injecting malicious payloads into the `CQL_FILTER` parameter. For experimental purposes, the script uses `SELECT version()` SQL statement as payload.

## Usage
To use this script, provide the target URL as a command-line parameter. For example:
```console
foo@bar:~$ python3 CVE-2023-25157.py <URL>
```
Replace `<URL>` with the actual URL of the target server.

![2023-06-06_20-37](https://github.com/win3zz/CVE-2023-25157/assets/12781459/44aaf525-918e-4ed2-b535-63706889ccd8)

## Google Dork
```inurl:"/geoserver/ows?service=wfs"```

![googledork](https://github.com/win3zz/CVE-2023-25157/assets/12781459/4ff54b26-861e-4bd2-9d39-2b16f7991644)

## References 
1. Security Advisory: [https://github.com/geoserver/geoserver/security/advisories/GHSA-7g5f-wrx8-5ccf](https://github.com/geoserver/geoserver/security/advisories/GHSA-7g5f-wrx8-5ccf)
2. Commit: [https://github.com/geoserver/geoserver/commit/145a8af798590288d270b240235e89c8f0b62e1d](https://github.com/geoserver/geoserver/commit/145a8af798590288d270b240235e89c8f0b62e1d)
3. Tweet: [https://twitter.com/parzel2/status/1665726454489915395](https://twitter.com/parzel2/status/1665726454489915395)

## Legal Disclaimer

The PoC script provided in this repository is intended for educational and research purposes only. It is designed to demonstrate the existence of a vulnerability and assist in understanding potential security risks.

**Usage of this script for any unauthorized activities, including but not limited to unauthorized access, unauthorized testing, or any other form of misuse, is strictly prohibited.**

The author and contributors of this repository assume no liability and are not responsible for any misuse or damages caused by the utilization of this script. By using this script, you agree to use it responsibly and at your own risk.

Always obtain proper authorization and permissions before conducting any security assessments or penetration testing activities. Ensure that you comply with all applicable laws, regulations, and ethical guidelines.



**Script Author:** Bipin Jitiya ([@win3zz](https://twitter.com/win3zz))
