# Injection vulnerability in Paradox Security Systems IPR512 - CVE-2023-24709 PoC
In Paradox Security System IPR512 web panel, an unauthenticated user can input JavaScript string, such as <code></script></code> that will overwrite configurations in the file "login.xml" and cause the login form to crash and make it unavailable. 

<img src="https://github.com/user-attachments/assets/dec82794-e77b-42d0-aa17-664a64da80f7" width="800">

**!!! WARNING !!! THE SCRIPT ACTUALLY DAMAGES THE SERVICE.**

**_Be aware that by following the exploitation steps manually and/or executing the exploitation script against any target, you acknowledge that you understand the potential risks, including possible damage to the system. The author of this script is not responsible for any type of harm, loss, or damage resulting from its use. Use the script at your own risk and ensure you have adequate backups and safeguards in place before proceeding._**

**Scripting Approach**
1. An example of successful attempt of exploitation

![screenshot](/img/pss_00.png)

2. An example of unsuccessful attempt of exploitation
   
![screenshot](/img/pss_01.png)




 
**Manual Approach**

1. The Paradox Security Systems IPR512 Account Management webpanel is accessible. Typing "admin" as a user.
  
![screenshot](/img/pss_1.png)
  
2. Intercepting request with BurpSuite.
  
![screenshot](/img/pss_2.png)

3. Changing "admin" with JavaScript tag <code></script></code>
  
![screenshot](/img/pss_3.png)

4. URL encoding <code></script></code> to bypass security filter and sending request.

![screenshot](/img/pss_4.png)

5. If accessing the login.xml isn't restricted, you can check that it is overwritten.
  
![screenshot](/img/pss_5.png)

6. The webpanel login form isn't accessible anymore as it is crashed.
  
![screenshot](/img/pss_6.png)

Code injection vulnerability in login.html in Web panel login page on IPR512 of the Paradox Security Systems product that allows a remote or local attacker to cause the web panel login page crash via injecting easy JavaScript code into login form page such as <code></script></code>. 

## Contact
If you have a question, you can contact me, [Giorgi Dograshvili](https://linkedin.com/in/giorgi-dograshvili) on LinkedIn.
