# CVE-2023-24278 - Reflected XSS Vulnerabilities in Squidex

## Overview
**CVE ID:** [CVE-2023-24278](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2023-24278)  
**Affected Products:** Squidex versions prior to 7.4.0  
**Reported By:** Ioannis Christodoulakos  

This repository provides information and an exploit for two Reflected Cross-Site Scripting (XSS) vulnerabilities discovered in the Squidex open-source headless CMS software. These vulnerabilities affect all versions prior to 7.4.0 and enable attackers to execute malicious JavaScript code in victim browsers by embedding code into specific query parameters of the `/squid.svg` endpoint.

## Vulnerability Details
The vulnerabilities exist due to improper sanitization of user-supplied input in the `text` and `background` parameters of the `/squid.svg` endpoint. Malicious input passed to these parameters is embedded directly into an auto-generated SVG image, which is then reflected back to the user's browser. This allows attackers to inject and execute arbitrary JavaScript code.

## Exploit CVE-2023-24278
Below is a proof-of-concept (PoC) exploit demonstrating how the vulnerability can be exploited via the `background` parameter.

### Exploit Steps
1. Send the following malicious GET requests to the vulnerable endpoint:

   **Exploiting `background` Parameter:**
   ```http
   GET /squid.svg?title=Not%20Found&text=This%20is%20not%20the%20page%20you%20are%20looking%20for!&background=%22%3E%3Cscript%3Ealert(1)%3C/script%3E%3Cimg%20src=%22&small HTTP/2
   ```

2. The server will respond with an SVG image containing the injected JavaScript code.

3. When the victim clicks on the malicious link, the JavaScript code will execute in their browser.

---

## Mitigation
To address this issue:
1. **Upgrade to Squidex 7.4.0 or newer.**
2. Validate and sanitize all user-supplied input before embedding it into dynamically generated SVG files.

For more details, refer to the [official advisory](https://census-labs.com/news/2023/03/16/reflected-xss-vulnerabilities-in-squidex-squidsvg-endpoint/).

